/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.control;

import edu.colorado.phet.capacitorlab.CLPaints;
import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.view.meters.TimesTenValueNode;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.event.HighlightHandler;
import edu.colorado.phet.common.piccolophet.event.SliderThumbDragHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JPanel;

public class CapacitanceControlNode
extends PhetPNode {
    private static final PDimension TRACK_SIZE = new PDimension(5.0, 125.0);
    private static final Color TRACK_FILL_COLOR = Color.LIGHT_GRAY;
    private static final Color TRACK_STROKE_COLOR = Color.BLACK;
    private static final Stroke TRACK_STROKE = new BasicStroke(1.0f);
    private static final PDimension KNOB_SIZE = new PDimension(20.0, 15.0);
    private static final Stroke KNOB_STROKE = new BasicStroke(1.0f);
    private static final Color KNOB_NORMAL_COLOR = CLPaints.DRAGGABLE_NORMAL;
    private static final Color KNOB_HIGHLIGHT_COLOR = CLPaints.DRAGGABLE_HIGHLIGHT;
    private static final Color KNOB_STROKE_COLOR = Color.BLACK;
    private static final double BACKGROUND_Y_MARGIN = KNOB_SIZE.getHeight() / 2.0 + 4.0;
    private static final Stroke BACKGROUND_STROKE = new BasicStroke(1.0f);
    private static final Color BACKGROUND_STROKE_COLOR = Color.BLACK;
    private static final Color BACKGROUND_FILL_COLOR = new JPanel().getBackground();
    private static final Font TITLE_FONT = new PhetFont(1, 16);
    private static final Color TITLE_COLOR = Color.BLACK;
    private static final NumberFormat VALUE_FORMAT = new DecimalFormat("0.00");
    private static final PhetFont VALUE_FONT = new PhetFont(16);
    private static final Color VALUE_COLOR = Color.BLACK;
    private final Capacitor capacitor;
    private final TrackNode trackNode;
    private final KnobNode knobNode;
    private final TitleNode titleNode;
    private final DoubleRange range;
    private final TimesTenValueNode valueNode;
    private final double snapInterval;

    public CapacitanceControlNode(Capacitor capacitor, DoubleRange doubleRange, int n) {
        this.range = doubleRange;
        this.snapInterval = Math.pow(10.0, n - 1);
        this.capacitor = capacitor;
        capacitor.addCapacitorChangeListener(new Capacitor.CapacitorChangeListener(){

            public void capacitorChanged() {
                CapacitanceControlNode.this.update();
            }
        });
        this.trackNode = new TrackNode();
        this.knobNode = new KnobNode(this, this.trackNode, doubleRange, this.snapInterval, capacitor);
        this.titleNode = new TitleNode(CLStrings.CAPACITANCE);
        this.valueNode = new TimesTenValueNode(VALUE_FORMAT, n, CLStrings.FARADS, capacitor.getTotalCapacitance(), VALUE_FONT, VALUE_COLOR);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.knobNode.getFullBoundsReference().getWidth() + 6.0, this.trackNode.getFullBoundsReference().getHeight() + 2.0 * BACKGROUND_Y_MARGIN);
        PPath pPath = new PPath(double_);
        pPath.setStroke(BACKGROUND_STROKE);
        pPath.setStrokePaint(BACKGROUND_STROKE_COLOR);
        pPath.setPaint(BACKGROUND_FILL_COLOR);
        this.addChild(pPath);
        this.addChild(this.trackNode);
        this.addChild(this.knobNode);
        this.addChild(this.titleNode);
        this.addChild(this.valueNode);
        double d = 0.0;
        double d2 = 0.0;
        pPath.setOffset(d, d2);
        d = pPath.getFullBoundsReference().getCenterX() - this.trackNode.getFullBoundsReference().getWidth() / 2.0;
        d2 = pPath.getFullBoundsReference().getCenterY() - this.trackNode.getFullBoundsReference().getHeight() / 2.0;
        this.trackNode.setOffset(d, d2);
        d = pPath.getFullBoundsReference().getCenterX() + this.knobNode.getFullBoundsReference().getWidth() / 2.0;
        d2 = pPath.getFullBoundsReference().getCenterY();
        this.knobNode.setOffset(d, d2);
        d = pPath.getFullBoundsReference().getCenterX() - this.titleNode.getFullBoundsReference().getWidth() / 2.0;
        d2 = pPath.getFullBoundsReference().getMaxY() + 2.0;
        this.titleNode.setOffset(d, d2);
        this.update();
    }

    private void update() {
        double d = this.capacitor.getTotalCapacitance();
        double d2 = this.knobNode.getXOffset();
        double d3 = this.trackNode.getYOffset() + this.trackNode.getFullBoundsReference().getHeight() * ((this.range.getMax() - d) / this.range.getLength());
        this.knobNode.setOffset(d2, d3);
        this.valueNode.setValue(d);
        d2 = this.titleNode.getFullBoundsReference().getCenterX() - this.valueNode.getFullBoundsReference().getWidth() / 2.0;
        d3 = this.titleNode.getFullBoundsReference().getMaxY() + 3.0;
        this.valueNode.setOffset(d2, d3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KnobDragHandler
    extends SliderThumbDragHandler {
        private final double snapInterval;

        public KnobDragHandler(PNode pNode, PNode pNode2, PNode pNode3, DoubleRange doubleRange, double d, VoidFunction1<Double> voidFunction1) {
            super(SliderThumbDragHandler.Orientation.VERTICAL, pNode, pNode2, pNode3, doubleRange, voidFunction1);
            this.snapInterval = d;
        }

        @Override
        protected double adjustValue(double d) {
            return Math.floor(d / this.snapInterval + 0.5) * this.snapInterval;
        }
    }

    private static class KnobNode
    extends PPath {
        public KnobNode(PNode pNode, PNode pNode2, DoubleRange doubleRange, double d, final Capacitor capacitor) {
            float f = (float)KNOB_SIZE.getWidth();
            float f2 = (float)KNOB_SIZE.getHeight();
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(0.35f * -f, f2 / 2.0f);
            generalPath.lineTo(-f, f2 / 2.0f);
            generalPath.lineTo(-f, -f2 / 2.0f);
            generalPath.lineTo(0.35f * -f, -f2 / 2.0f);
            generalPath.closePath();
            this.setPathTo(generalPath);
            this.setPaint(KNOB_NORMAL_COLOR);
            this.setStroke(KNOB_STROKE);
            this.setStrokePaint(KNOB_STROKE_COLOR);
            this.addInputEventListener(new CursorHandler());
            this.addInputEventListener(new HighlightHandler.PaintHighlightHandler(this, KNOB_NORMAL_COLOR, KNOB_HIGHLIGHT_COLOR));
            this.addInputEventListener(new KnobDragHandler(pNode, pNode2, (PNode)this, doubleRange, d, new VoidFunction1<Double>(){

                @Override
                public void apply(Double d) {
                    capacitor.setTotalCapacitance(d);
                }
            }));
        }
    }

    private static class TitleNode
    extends PText {
        public TitleNode(String string) {
            super(string);
            this.setTextPaint(TITLE_COLOR);
            this.setFont(TITLE_FONT);
        }
    }

    private static class TrackNode
    extends PPath {
        public TrackNode() {
            this.setPathTo(new Rectangle2D.Double(0.0, 0.0, TRACK_SIZE.width, TRACK_SIZE.height));
            this.setPaint(TRACK_FILL_COLOR);
            this.setStrokePaint(TRACK_STROKE_COLOR);
            this.setStroke(TRACK_STROKE);
        }
    }
}

