/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.control;

import edu.colorado.phet.capacitorlab.CLConstants;
import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.capacitorlab.control.DielectricChargesControl;
import edu.colorado.phet.capacitorlab.control.DielectricConstantControl;
import edu.colorado.phet.capacitorlab.control.DielectricMaterialControl;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.model.DielectricChargeView;
import edu.colorado.phet.capacitorlab.model.DielectricMaterial;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.ColoredSeparator;
import edu.colorado.phet.common.phetcommon.view.PhetTitledPanel;
import edu.colorado.phet.common.phetcommon.view.util.GridPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DielectricPropertiesControlPanel
extends PhetTitledPanel {
    private final Capacitor capacitor;
    private final SimpleObserver dielectricConstantObserver;
    private final DielectricMaterialControl materialControl;
    private final DielectricConstantControl constantControl;
    private DielectricMaterial material;

    public DielectricPropertiesControlPanel(final Capacitor capacitor, DielectricMaterial[] dielectricMaterialArray, Property<DielectricChargeView> property) {
        super(CLStrings.DIELECTRIC);
        this.capacitor = capacitor;
        this.material = capacitor.getDielectricMaterial();
        this.dielectricConstantObserver = new SimpleObserver(){

            public void update() {
                DielectricPropertiesControlPanel.this.handleDielectricConstantChanged();
            }
        };
        this.materialControl = new DielectricMaterialControl(dielectricMaterialArray, capacitor.getDielectricMaterial());
        this.materialControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                capacitor.setDielectricMaterial(DielectricPropertiesControlPanel.this.materialControl.getMaterial());
            }
        });
        this.constantControl = new DielectricConstantControl(CLConstants.DIELECTRIC_CONSTANT_RANGE.getDefault());
        this.constantControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (capacitor.getDielectricMaterial() instanceof DielectricMaterial.CustomDielectricMaterial) {
                    ((DielectricMaterial.CustomDielectricMaterial)capacitor.getDielectricMaterial()).setDielectricConstant(DielectricPropertiesControlPanel.this.constantControl.getValue());
                }
            }
        });
        DielectricChargesControl dielectricChargesControl = new DielectricChargesControl(property);
        GridPanel gridPanel = new GridPanel();
        gridPanel.setInsets(new Insets(0, 5, 5, 0));
        gridPanel.setAnchor(GridPanel.Anchor.WEST);
        gridPanel.setFill(GridPanel.Fill.HORIZONTAL);
        gridPanel.setGridX(0);
        gridPanel.add(this.materialControl);
        gridPanel.add(new ColoredSeparator.BlackSeparator());
        gridPanel.add(this.constantControl);
        gridPanel.add(new ColoredSeparator.BlackSeparator());
        gridPanel.add(dielectricChargesControl);
        this.setLayout(new BorderLayout());
        this.add((Component)gridPanel, "West");
        capacitor.addDielectricMaterialObserver(new SimpleObserver(){

            public void update() {
                DielectricPropertiesControlPanel.this.handleDielectricMaterialChanged();
            }
        });
        this.material.addDielectricConstantObserver(this.dielectricConstantObserver);
    }

    private void handleDielectricMaterialChanged() {
        DielectricMaterial dielectricMaterial = this.capacitor.getDielectricMaterial();
        this.materialControl.setMaterial(dielectricMaterial);
        this.constantControl.setEnabled(dielectricMaterial instanceof DielectricMaterial.CustomDielectricMaterial);
        this.constantControl.setValue(dielectricMaterial.getDielectricConstant());
        this.material.removeDielectricConstantObserver(this.dielectricConstantObserver);
        this.material = dielectricMaterial;
        this.material.addDielectricConstantObserver(this.dielectricConstantObserver);
    }

    private void handleDielectricConstantChanged() {
        this.constantControl.setValue(this.capacitor.getDielectricMaterial().getDielectricConstant());
    }
}

