/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.control;

import edu.colorado.phet.capacitorlab.CLPaints;
import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.capacitorlab.model.circuit.ICircuit;
import edu.colorado.phet.capacitorlab.model.circuit.SingleCircuit;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.event.HighlightHandler;
import edu.colorado.phet.common.piccolophet.event.SliderThumbDragHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class PlateChargeControlNode
extends PhetPNode {
    private static final PDimension TRACK_SIZE = new PDimension(5.0, 200.0);
    private static final Color TRACK_FILL_COLOR = Color.LIGHT_GRAY;
    private static final Color TRACK_STROKE_COLOR = Color.BLACK;
    private static final Stroke TRACK_STROKE = new BasicStroke(1.0f);
    private static final Stroke BACKGROUND_STROKE = new BasicStroke(1.0f);
    private static final Color BACKGROUND_STROKE_COLOR = Color.BLACK;
    private static final Color BACKGROUND_FILL_COLOR = new JPanel().getBackground();
    private static final PDimension KNOB_SIZE = new PDimension(20.0, 15.0);
    private static final Stroke KNOB_STROKE = new BasicStroke(1.0f);
    private static final Color KNOB_NORMAL_COLOR = CLPaints.DRAGGABLE_NORMAL;
    private static final Color KNOB_HIGHLIGHT_COLOR = CLPaints.DRAGGABLE_HIGHLIGHT;
    private static final Color KNOB_STROKE_COLOR = Color.BLACK;
    private static final Color TICK_MARK_COLOR = TRACK_STROKE_COLOR;
    private static final Stroke TICK_MARK_STROKE = TRACK_STROKE;
    private static final Font RANGE_LABEL_FONT = new PhetFont(14);
    private static final Color RANGE_LABEL_COLOR = Color.BLACK;
    private static final Font TITLE_FONT = new PhetFont(1, 16);
    private static final Color TITLE_COLOR = Color.BLACK;
    private final SingleCircuit circuit;
    private final SliderNode sliderNode;
    private final DoubleRange range;

    public PlateChargeControlNode(final SingleCircuit singleCircuit, DoubleRange doubleRange) {
        this.range = doubleRange;
        this.circuit = singleCircuit;
        singleCircuit.addCircuitChangeListener(new ICircuit.CircuitChangeListener(){

            public void circuitChanged() {
                if (!singleCircuit.isBatteryConnected()) {
                    PlateChargeControlNode.this.update();
                }
            }
        });
        this.sliderNode = new SliderNode(singleCircuit, doubleRange);
        double d = this.sliderNode.getFullBoundsReference().getWidth() + 20.0;
        double d2 = this.sliderNode.getFullBoundsReference().getHeight() + 10.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, d, d2);
        PPath pPath = new PPath(double_);
        pPath.setStroke(BACKGROUND_STROKE);
        pPath.setStrokePaint(BACKGROUND_STROKE_COLOR);
        pPath.setPaint(BACKGROUND_FILL_COLOR);
        TitleNode titleNode = new TitleNode(CLStrings.PLATE_CHARGE_TOP);
        this.addChild(pPath);
        this.addChild(this.sliderNode);
        this.addChild(titleNode);
        double d3 = 0.0;
        double d4 = 0.0;
        pPath.setOffset(d3, d4);
        d3 = pPath.getFullBoundsReference().getCenterX() - this.sliderNode.getFullBoundsReference().getWidth() / 2.0 - PNodeLayoutUtils.getOriginXOffset(this.sliderNode);
        d4 = pPath.getFullBoundsReference().getCenterY() - this.sliderNode.getFullBoundsReference().getHeight() / 2.0 - PNodeLayoutUtils.getOriginYOffset(this.sliderNode);
        this.sliderNode.setOffset(d3, d4);
        d3 = pPath.getFullBoundsReference().getCenterX() - titleNode.getFullBoundsReference().getWidth() / 2.0;
        d4 = pPath.getFullBoundsReference().getMaxY() + 2.0;
        titleNode.setOffset(d3, d4);
        this.update();
    }

    private void update() {
        double d = this.circuit.getDisconnectedPlateCharge();
        double d2 = this.sliderNode.knobNode.getXOffset();
        double d3 = this.sliderNode.trackNode.getFullBoundsReference().getHeight() * ((this.range.getMax() - d) / this.range.getLength());
        this.sliderNode.knobNode.setOffset(d2, d3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KnobDragHandler
    extends SliderThumbDragHandler {
        private final double snapThreshold;

        public KnobDragHandler(PNode pNode, PNode pNode2, PNode pNode3, DoubleRange doubleRange, double d, VoidFunction1<Double> voidFunction1) {
            super(SliderThumbDragHandler.Orientation.VERTICAL, pNode, pNode2, pNode3, doubleRange, voidFunction1);
            this.snapThreshold = d;
        }

        @Override
        protected double adjustValue(double d) {
            return Math.abs(d) <= this.snapThreshold ? 0.0 : d;
        }
    }

    private static class KnobNode
    extends PPath {
        public KnobNode(PNode pNode, PNode pNode2, DoubleRange doubleRange, final SingleCircuit singleCircuit) {
            float f = (float)KNOB_SIZE.getWidth();
            float f2 = (float)KNOB_SIZE.getHeight();
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(0.35f * f, f2 / 2.0f);
            generalPath.lineTo(f, f2 / 2.0f);
            generalPath.lineTo(f, -f2 / 2.0f);
            generalPath.lineTo(0.35f * f, -f2 / 2.0f);
            generalPath.closePath();
            this.setPathTo(generalPath);
            this.setPaint(KNOB_NORMAL_COLOR);
            this.setStroke(KNOB_STROKE);
            this.setStrokePaint(KNOB_STROKE_COLOR);
            this.addInputEventListener(new CursorHandler());
            this.addInputEventListener(new HighlightHandler.PaintHighlightHandler(this, KNOB_NORMAL_COLOR, KNOB_HIGHLIGHT_COLOR));
            this.addInputEventListener(new KnobDragHandler(pNode, pNode2, (PNode)this, doubleRange, 1.5E-13, new VoidFunction1<Double>(){

                @Override
                public void apply(Double d) {
                    singleCircuit.setDisconnectedPlateCharge(d);
                }
            }));
        }
    }

    private static class RangeLabelNode
    extends HTMLNode {
        public RangeLabelNode(String string) {
            super(string);
            this.setHTMLColor(RANGE_LABEL_COLOR);
            this.setFont(RANGE_LABEL_FONT);
        }
    }

    private static class SliderNode
    extends PhetPNode {
        public final TrackNode trackNode = new TrackNode();
        public final KnobNode knobNode;

        public SliderNode(SingleCircuit singleCircuit, DoubleRange doubleRange) {
            this.knobNode = new KnobNode(this, this.trackNode, doubleRange, singleCircuit);
            TickMarkNode tickMarkNode = new TickMarkNode();
            RangeLabelNode rangeLabelNode = new RangeLabelNode(CLStrings.LOTS_POSITIVE);
            TickMarkNode tickMarkNode2 = new TickMarkNode();
            RangeLabelNode rangeLabelNode2 = new RangeLabelNode(CLStrings.NONE);
            TickMarkNode tickMarkNode3 = new TickMarkNode();
            RangeLabelNode rangeLabelNode3 = new RangeLabelNode(CLStrings.LOTS_NEGATIVE);
            this.addChild(this.trackNode);
            this.addChild(tickMarkNode);
            this.addChild(rangeLabelNode);
            this.addChild(tickMarkNode2);
            this.addChild(rangeLabelNode2);
            this.addChild(tickMarkNode3);
            this.addChild(rangeLabelNode3);
            this.addChild(this.knobNode);
            double d = 0.0;
            double d2 = 0.0;
            this.trackNode.setOffset(d, d2);
            d = -5.0;
            d2 = 0.0;
            this.knobNode.setOffset(d, d2);
            d = -tickMarkNode.getFullBoundsReference().getWidth();
            d2 = this.trackNode.getFullBoundsReference().getMinY() + tickMarkNode.getFullBoundsReference().getHeight() / 2.0;
            tickMarkNode.setOffset(d, d2);
            d = tickMarkNode.getFullBoundsReference().getMinX() - rangeLabelNode.getFullBoundsReference().getWidth() - 3.0;
            d2 = tickMarkNode.getFullBoundsReference().getCenterY() - rangeLabelNode.getFullBoundsReference().getHeight() / 2.0;
            rangeLabelNode.setOffset(d, d2);
            d = -tickMarkNode2.getFullBoundsReference().getWidth();
            d2 = this.trackNode.getFullBoundsReference().getCenterY() - tickMarkNode2.getFullBoundsReference().getHeight() / 2.0 + 1.0;
            tickMarkNode2.setOffset(d, d2);
            d = tickMarkNode2.getFullBoundsReference().getMinX() - rangeLabelNode2.getFullBoundsReference().getWidth() - 3.0;
            d2 = tickMarkNode2.getFullBoundsReference().getCenterY() - rangeLabelNode2.getFullBoundsReference().getHeight() / 2.0;
            rangeLabelNode2.setOffset(d, d2);
            d = -tickMarkNode3.getFullBoundsReference().getWidth();
            d2 = this.trackNode.getFullBoundsReference().getMaxY();
            tickMarkNode3.setOffset(d, d2);
            d = tickMarkNode3.getFullBoundsReference().getMinX() - rangeLabelNode3.getFullBoundsReference().getWidth() - 3.0;
            d2 = tickMarkNode3.getFullBoundsReference().getCenterY() - rangeLabelNode3.getFullBoundsReference().getHeight() / 2.0;
            rangeLabelNode3.setOffset(d, d2);
        }
    }

    private static class TickMarkNode
    extends PPath {
        public TickMarkNode() {
            super(new Line2D.Double(0.0, 0.0, 8.0, 0.0));
            this.setStrokePaint(TICK_MARK_COLOR);
            this.setStroke(TICK_MARK_STROKE);
        }
    }

    private static class TitleNode
    extends PText {
        public TitleNode(String string) {
            super(string);
            this.setTextPaint(TITLE_COLOR);
            this.setFont(TITLE_FONT);
        }
    }

    private static class TrackNode
    extends PPath {
        public TrackNode() {
            this.setPathTo(new Rectangle2D.Double(0.0, 0.0, TRACK_SIZE.width, TRACK_SIZE.height));
            this.setPaint(TRACK_FILL_COLOR);
            this.setStrokePaint(TRACK_STROKE_COLOR);
            this.setStroke(TRACK_STROKE);
        }
    }
}

