/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.developer;

import edu.colorado.phet.capacitorlab.model.Battery;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.model.DielectricMaterial;
import edu.colorado.phet.capacitorlab.model.circuit.ICircuit;
import edu.colorado.phet.capacitorlab.model.circuit.SingleCircuit;
import edu.colorado.phet.capacitorlab.module.dielectric.DielectricModel;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.GridPanel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;

class DielectricModelValuesPanel
extends JPanel {
    private static final Font VALUE_DISPLAY_FONT = new PhetFont(10);
    private final DielectricModel model;
    private final ValueDisplay V_battery;
    private final ValueDisplay Q_disconnected;
    private final ValueDisplay L;
    private final ValueDisplay d;
    private final ValueDisplay offset;
    private final ValueDisplay epsilon_dielectric;
    private final ValueDisplay A_dielectric;
    private final ValueDisplay A_air;
    private final ValueDisplay A_plate;
    private final ValueDisplay C_air;
    private final ValueDisplay C_dielectric;
    private final ValueDisplay C;
    private final ValueDisplay V_plates;
    private final ValueDisplay Q_air;
    private final ValueDisplay Q_dielectric;
    private final ValueDisplay Q_total;
    private final ValueDisplay Q_excess_air;
    private final ValueDisplay Q_excess_dielectric;
    private final ValueDisplay E_effective;
    private final ValueDisplay E_plates_air;
    private final ValueDisplay E_plates_dielectric;
    private final ValueDisplay E_air;
    private final ValueDisplay E_dielectric;
    private final ValueDisplay U;
    private DielectricMaterial dielectricMaterial;
    private final SimpleObserver dielectricConstantObserver;
    private final ICircuit.CircuitChangeListener circuitChangeListener;

    public DielectricModelValuesPanel(DielectricModel dielectricModel) {
        this.model = dielectricModel;
        this.dielectricMaterial = dielectricModel.circuit.getCapacitor().getDielectricMaterial();
        JLabel jLabel = new JLabel("= MOUSE OVER FOR DESCRIPTIONS =");
        jLabel.setForeground(Color.RED);
        jLabel.setFont(VALUE_DISPLAY_FONT);
        VerticalPanel verticalPanel = new VerticalPanel();
        verticalPanel.setBorder(new TitledBorder("Constants"));
        ValueDisplay valueDisplay = new ValueDisplay("\u0190_0", "F/m", "0.000E00", 8.854E-12);
        valueDisplay.setToolTipText("vacuum permittivity");
        ((Container)verticalPanel).add(valueDisplay);
        ValueDisplay valueDisplay2 = new ValueDisplay("\u0190_air", "", "0.00000000", 1.0);
        valueDisplay2.setToolTipText("dielectric constant of air");
        ((Container)verticalPanel).add(valueDisplay2);
        ValueDisplay valueDisplay3 = new ValueDisplay("\u0190_vacuum", "", "0.0", 1.0);
        valueDisplay3.setToolTipText("dielectric constant of a vacuum");
        ((Container)verticalPanel).add(valueDisplay3);
        VerticalPanel verticalPanel2 = new VerticalPanel();
        verticalPanel2.setBorder(new TitledBorder("User Settings"));
        this.V_battery = new ValueDisplay("V_battery", "V", "0.00");
        this.V_battery.setToolTipText("battery voltage");
        ((Container)verticalPanel2).add(this.V_battery);
        this.Q_disconnected = new ValueDisplay("Q_disconnected", "C", "0.000E00");
        this.Q_disconnected.setToolTipText("<html>total plate change when<br>battery is disconnected</html>");
        ((Container)verticalPanel2).add(this.Q_disconnected);
        this.L = new ValueDisplay("L", "m", "0.0000");
        this.L.setToolTipText("plate side length");
        ((Container)verticalPanel2).add(this.L);
        this.d = new ValueDisplay("d", "m", "0.0000");
        this.d.setToolTipText("plate separation distance");
        ((Container)verticalPanel2).add(this.d);
        this.offset = new ValueDisplay("offset", "m", "0.000");
        this.offset.setToolTipText("how far the dielectric is pulled out");
        ((Container)verticalPanel2).add(this.offset);
        this.epsilon_dielectric = new ValueDisplay("\u0190_dielectric", "", "0.000");
        this.epsilon_dielectric.setToolTipText("dielectric constant");
        ((Container)verticalPanel2).add(this.epsilon_dielectric);
        VerticalPanel verticalPanel3 = new VerticalPanel();
        verticalPanel3.setBorder(new TitledBorder("Derived"));
        this.A_dielectric = new ValueDisplay("A_dielectric", "m^2", "0.000000");
        this.A_dielectric.setToolTipText("area of dielectric between the plates");
        ((Container)verticalPanel3).add(this.A_dielectric);
        this.A_air = new ValueDisplay("A_air", "m^2", "0.000000");
        this.A_air.setToolTipText("area of air between the plates");
        ((Container)verticalPanel3).add(this.A_air);
        this.A_plate = new ValueDisplay("A_plate", "m^2", "0.000000");
        this.A_plate.setToolTipText("plate area");
        ((Container)verticalPanel3).add(this.A_plate);
        ((Container)verticalPanel3).add(new JSeparator());
        this.C_air = new ValueDisplay("C_air", "F", "0.000E00");
        this.C_air.setToolTipText("capacitance due to air");
        ((Container)verticalPanel3).add(this.C_air);
        this.C_dielectric = new ValueDisplay("C_dielectric", "F", "0.000E00");
        this.C_dielectric.setToolTipText("capacitance due to dielectric");
        ((Container)verticalPanel3).add(this.C_dielectric);
        this.C = new ValueDisplay("C_total", "F", "0.000E00");
        this.C.setToolTipText("total capacitance");
        ((Container)verticalPanel3).add(this.C);
        ((Container)verticalPanel3).add(new JSeparator());
        this.V_plates = new ValueDisplay("V_plate", "V", "0.00");
        this.V_plates.setToolTipText("voltage difference between plates");
        ((Container)verticalPanel3).add(this.V_plates);
        ((Container)verticalPanel3).add(new JSeparator());
        this.Q_air = new ValueDisplay("Q_air", "C", "0.000E00");
        this.Q_air.setToolTipText("plate charge due to air");
        ((Container)verticalPanel3).add(this.Q_air);
        this.Q_dielectric = new ValueDisplay("Q_dielectric", "C", "0.000E00");
        this.Q_dielectric.setToolTipText("plate charge due to dielectric");
        ((Container)verticalPanel3).add(this.Q_dielectric);
        this.Q_total = new ValueDisplay("Q_total", "C", "0.000E00");
        this.Q_total.setToolTipText("total charge on top plate");
        ((Container)verticalPanel3).add(this.Q_total);
        this.Q_excess_air = new ValueDisplay("Q_excess_air", "C", "0.000E00");
        this.Q_excess_air.setToolTipText("excess charge due to air");
        ((Container)verticalPanel3).add(this.Q_excess_air);
        this.Q_excess_dielectric = new ValueDisplay("Q_excess_dielectric", "C", "0.000E00");
        this.Q_excess_dielectric.setToolTipText("excess charge due to dielectric");
        ((Container)verticalPanel3).add(this.Q_excess_dielectric);
        ((Container)verticalPanel3).add(new JSeparator());
        this.E_effective = new ValueDisplay("E_effective", "V/m", "0.000E00");
        this.E_effective.setToolTipText("effective field between plates");
        ((Container)verticalPanel3).add(this.E_effective);
        this.E_plates_air = new ValueDisplay("E_plates_air", "V/m", "0.000E00");
        this.E_plates_air.setToolTipText("<html>field due to the plates in the<br>capacitor volume that contains air</html>");
        ((Container)verticalPanel3).add(this.E_plates_air);
        this.E_plates_dielectric = new ValueDisplay("E_plates_dielectric", "V/m", "0.000E00");
        this.E_plates_dielectric.setToolTipText("<html>field due to the plates in the<br>capacitor volume that contains dielectric</html>");
        ((Container)verticalPanel3).add(this.E_plates_dielectric);
        this.E_air = new ValueDisplay("E_air", "V/m", "0.000E00");
        this.E_air.setToolTipText("field in air volume");
        ((Container)verticalPanel3).add(this.E_air);
        this.E_dielectric = new ValueDisplay("E_dielectric", "V/m", "0.000E00");
        this.E_dielectric.setToolTipText("field in dielectric volume");
        ((Container)verticalPanel3).add(this.E_dielectric);
        ((Container)verticalPanel3).add(new JSeparator());
        this.U = new ValueDisplay("U", "J", "0.000E00");
        this.U.setToolTipText("stored energy");
        ((Container)verticalPanel3).add(this.U);
        VerticalPanel verticalPanel4 = new VerticalPanel();
        verticalPanel4.add(jLabel);
        verticalPanel4.add(verticalPanel);
        verticalPanel4.add(verticalPanel2);
        verticalPanel4.add(verticalPanel3);
        verticalPanel4.add(Box.createHorizontalStrut(180));
        this.setLayout(new BorderLayout());
        this.add((Component)verticalPanel4, "West");
        this.circuitChangeListener = new ICircuit.CircuitChangeListener(){

            public void circuitChanged() {
                DielectricModelValuesPanel.this.updateValues();
            }
        };
        dielectricModel.circuit.addCircuitChangeListener(this.circuitChangeListener);
        this.dielectricConstantObserver = new SimpleObserver(){

            public void update() {
                DielectricModelValuesPanel.this.updateValues();
            }
        };
        this.dielectricMaterial.addDielectricConstantObserver(this.dielectricConstantObserver);
        dielectricModel.circuit.getCapacitor().addDielectricMaterialObserver(new SimpleObserver(){

            public void update() {
                DielectricModelValuesPanel.this.updateDielectricObserver();
            }
        });
        this.updateValues();
    }

    public void cleanup() {
        this.model.circuit.removeCircuitChangeListener(this.circuitChangeListener);
        this.dielectricMaterial.removeDielectricConstantObserver(this.dielectricConstantObserver);
    }

    private void updateValues() {
        SingleCircuit singleCircuit = this.model.circuit;
        Battery battery = singleCircuit.getBattery();
        Capacitor capacitor = singleCircuit.getCapacitor();
        this.V_battery.setValue(battery.getVoltage());
        this.Q_disconnected.setValue(singleCircuit.getDisconnectedPlateCharge());
        this.L.setValue(capacitor.getPlateWidth());
        this.d.setValue(capacitor.getPlateSeparation());
        this.offset.setValue(capacitor.getDielectricOffset());
        this.epsilon_dielectric.setValue(capacitor.getDielectricMaterial().getDielectricConstant());
        this.A_plate.setValue(capacitor.getPlateArea());
        this.A_dielectric.setValue(capacitor.getDielectricContactArea());
        this.A_air.setValue(capacitor.getAirContactArea());
        this.C_air.setValue(capacitor.getAirCapacitance());
        this.C_dielectric.setValue(capacitor.getDielectricCapacitance());
        this.C.setValue(capacitor.getTotalCapacitance());
        this.V_plates.setValue(capacitor.getPlatesVoltage());
        this.Q_air.setValue(capacitor.getAirPlateCharge());
        this.Q_dielectric.setValue(capacitor.getDielectricPlateCharge());
        this.Q_total.setValue(capacitor.getTotalPlateCharge());
        this.Q_excess_air.setValue(capacitor.getExcessAirPlateCharge());
        this.Q_excess_dielectric.setValue(capacitor.getExcessDielectricPlateCharge());
        this.E_effective.setValue(capacitor.getEffectiveEField());
        this.E_plates_air.setValue(capacitor.getPlatesAirEField());
        this.E_plates_dielectric.setValue(capacitor.getPlatesDielectricEField());
        this.E_air.setValue(capacitor.getAirEField());
        this.E_dielectric.setValue(capacitor.getDielectricEField());
        this.U.setValue(this.model.circuit.getStoredEnergy());
    }

    private void updateDielectricObserver() {
        this.dielectricMaterial.removeDielectricConstantObserver(this.dielectricConstantObserver);
        this.dielectricMaterial = this.model.circuit.getCapacitor().getDielectricMaterial();
        this.dielectricMaterial.addDielectricConstantObserver(this.dielectricConstantObserver);
    }

    private static class ValueDisplay
    extends JLabel {
        private final String label;
        private final String units;
        private final NumberFormat format;

        public ValueDisplay(String string, String string2, String string3) {
            this(string, string2, string3, 0.0);
        }

        public ValueDisplay(String string, String string2, String string3, double d) {
            this.setFont(VALUE_DISPLAY_FONT);
            this.label = string;
            this.units = string2;
            this.format = new DecimalFormat(string3);
            this.setValue(d);
        }

        public void setValue(double d) {
            String string = d == 0.0 ? "0" : this.format.format(d);
            this.setText(this.label + " = " + string + " " + this.units);
        }
    }

    private static class VerticalPanel
    extends JPanel {
        private final GridPanel innerPanel = new GridPanel();

        public VerticalPanel() {
            this.innerPanel.setAnchor(GridPanel.Anchor.WEST);
            this.innerPanel.setFill(GridPanel.Fill.HORIZONTAL);
            this.innerPanel.setGridX(0);
            this.setLayout(new BorderLayout());
            super.add((Component)this.innerPanel, "West");
        }

        public Component add(Component component) {
            this.innerPanel.add(component);
            return component;
        }
    }
}

