/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.drag;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Font;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;

class DragHandleValueNode
extends PComposite {
    private static final DecimalFormat DEFAULT_FORMAT = new DecimalFormat("0.0");
    private static final Font LABEL_FONT = new PhetFont(1, 18);
    private static final Font VALUE_FONT = new PhetFont(0, 16);
    private final String pattern;
    private final String units;
    private final NumberFormat format;
    private final HTMLNode valueNode;

    public DragHandleValueNode(String string, String string2, double d, String string3) {
        this(string, string2, d, string3, DEFAULT_FORMAT);
    }

    public DragHandleValueNode(String string, String string2, double d, String string3, NumberFormat numberFormat) {
        this.pattern = string;
        this.units = string3;
        this.format = numberFormat;
        PText pText = new PText(string2);
        pText.setFont(LABEL_FONT);
        this.addChild(pText);
        this.valueNode = new HTMLNode(){

            public boolean setBounds(double d, double d2, double d3, double d4) {
                return super.setBounds(d, d2, d3 + 2.0, d4);
            }
        };
        this.valueNode.setFont(VALUE_FONT);
        this.addChild(this.valueNode);
        pText.setOffset(0.0, 0.0);
        this.valueNode.setOffset(0.0, pText.getFullBoundsReference().getMaxY() + 1.0);
        this.setValue(d);
    }

    public void setValue(double d) {
        String string = this.format.format(d);
        String string2 = MessageFormat.format(this.pattern, string, this.units);
        this.valueNode.setHTML(string2);
    }
}

