/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.drag;

import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.capacitorlab.drag.DragHandleArrowNode;
import edu.colorado.phet.capacitorlab.drag.DragHandleLineNode;
import edu.colorado.phet.capacitorlab.drag.DragHandleValueNode;
import edu.colorado.phet.capacitorlab.drag.PlateAreaDragHandler;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.util.UnitsUtils;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import java.awt.geom.Point2D;

public class PlateAreaDragHandleNode
extends PhetPNode {
    private static final Point2D ARROW_TIP_LOCATION = new Point2D.Double(0.0, 0.0);
    private static final Point2D ARROW_TAIL_LOCATION = new Point2D.Double(0.0, 35.0);
    private static final Point2D LINE_START_LOCATION = new Point2D.Double(0.0, 0.0);
    private static final Point2D LINE_END_LOCATION = new Point2D.Double(0.0, 22.0);
    private final Capacitor capacitor;
    private final CLModelViewTransform3D mvt;
    private final DragHandleValueNode valueNode;

    public PlateAreaDragHandleNode(Capacitor capacitor, CLModelViewTransform3D cLModelViewTransform3D, DoubleRange doubleRange) {
        this.capacitor = capacitor;
        this.mvt = cLModelViewTransform3D;
        DragHandleArrowNode dragHandleArrowNode = new DragHandleArrowNode(ARROW_TIP_LOCATION, ARROW_TAIL_LOCATION);
        dragHandleArrowNode.addInputEventListener(new PlateAreaDragHandler(this, capacitor, cLModelViewTransform3D, doubleRange));
        DragHandleLineNode dragHandleLineNode = new DragHandleLineNode(LINE_START_LOCATION, LINE_END_LOCATION);
        double d = UnitsUtils.metersSquaredToMillimetersSquared(capacitor.getPlateArea());
        this.valueNode = new DragHandleValueNode(CLStrings.PATTERN_VALUE_UNITS, CLStrings.PLATE_AREA, d, CLStrings.MILLIMETERS_SQUARED);
        this.addChild(dragHandleLineNode);
        this.addChild(dragHandleArrowNode);
        this.addChild(this.valueNode);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 1.5707963267948966 + cLModelViewTransform3D.getYaw() / 2.0;
        dragHandleLineNode.setOffset(d2, d3);
        dragHandleLineNode.setRotation(d4);
        d2 = dragHandleLineNode.getFullBoundsReference().getMinX() - 2.0;
        d3 = dragHandleLineNode.getFullBoundsReference().getMaxY() + 2.0;
        dragHandleArrowNode.setOffset(d2, d3);
        dragHandleArrowNode.setRotation(d4);
        d2 = dragHandleLineNode.getFullBoundsReference().getMaxX() - this.valueNode.getFullBoundsReference().getWidth();
        d3 = dragHandleLineNode.getFullBoundsReference().getMinY() - this.valueNode.getFullBoundsReference().getHeight();
        this.valueNode.setOffset(d2, d3);
        capacitor.addPlateSizeObserver(new SimpleObserver(){

            public void update() {
                PlateAreaDragHandleNode.this.updateDisplay();
                PlateAreaDragHandleNode.this.updateOffset();
            }
        });
        capacitor.addPlateSeparationObserver(new SimpleObserver(){

            public void update() {
                PlateAreaDragHandleNode.this.updateOffset();
            }
        });
    }

    private void updateDisplay() {
        double d = UnitsUtils.metersSquaredToMillimetersSquared(this.capacitor.getPlateArea());
        this.valueNode.setValue(d);
    }

    private void updateOffset() {
        double d = this.capacitor.getX() - this.capacitor.getPlateWidth() / 2.0;
        double d2 = this.capacitor.getY() - this.capacitor.getPlateSeparation() / 2.0 - this.capacitor.getPlateHeight();
        double d3 = this.capacitor.getZ() - this.capacitor.getPlateDepth() / 2.0;
        Point2D point2D = this.mvt.modelToView(d, d2, d3);
        this.setOffset(point2D);
    }
}

