/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.model;

import edu.colorado.phet.capacitorlab.CLConstants;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class CLModelViewTransform3D {
    private final AffineTransform modelToViewTransform2D = new AffineTransform();
    private final AffineTransform viewToModelTransform2D;
    private final double pitch;
    private final double yaw;

    public CLModelViewTransform3D() {
        this(15000.0, CLConstants.MVT_PITCH, CLConstants.MVT_YAW);
    }

    public CLModelViewTransform3D(double d, double d2, double d3) {
        this.modelToViewTransform2D.scale(d, d);
        this.viewToModelTransform2D = new AffineTransform();
        this.viewToModelTransform2D.scale(1.0 / d, 1.0 / d);
        this.pitch = d2;
        this.yaw = d3;
    }

    public double getYaw() {
        return this.yaw;
    }

    public Point2D modelToView(Point3D point3D) {
        double d = point3D.getX() + point3D.getZ() * Math.sin(this.pitch) * Math.cos(this.yaw);
        double d2 = point3D.getY() + point3D.getZ() * Math.sin(this.pitch) * Math.sin(this.yaw);
        return this.modelToViewTransform2D.transform(new Point2D.Double(d, d2), null);
    }

    public Point2D modelToView(double d, double d2, double d3) {
        return this.modelToView(new Point3D.Double(d, d2, d3));
    }

    public Point2D modelToViewDelta(Point3D point3D) {
        Point2D point2D = this.modelToView(new Point3D.Double(0.0, 0.0, 0.0));
        Point2D point2D2 = this.modelToView(point3D);
        return new Point2D.Double(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
    }

    public Point2D modelToViewDelta(double d, double d2, double d3) {
        return this.modelToViewDelta(new Point3D.Double(d, d2, d3));
    }

    public Shape modelToView(Shape shape) {
        return this.modelToViewTransform2D.createTransformedShape(shape);
    }

    public Point3D viewToModel(Point2D point2D) {
        Point2D point2D2 = this.viewToModelTransform2D.transform(point2D, null);
        return new Point3D.Double(point2D2.getX(), point2D2.getY(), 0.0);
    }

    public Point3D viewToModel(double d, double d2) {
        return this.viewToModel(new Point2D.Double(d, d2));
    }

    public Point3D viewToModelDelta(Point2D point2D) {
        Point3D point3D = this.viewToModel(new Point2D.Double(0.0, 0.0));
        Point3D point3D2 = this.viewToModel(point2D);
        return new Point3D.Double(point3D2.getX() - point3D.getX(), point3D2.getY() - point3D.getY(), point3D2.getZ() - point3D.getZ());
    }

    public Point3D viewToModelDelta(double d, double d2) {
        return this.viewToModelDelta(new Point2D.Double(d, d2));
    }
}

