/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.model;

import edu.colorado.phet.capacitorlab.CLConstants;
import edu.colorado.phet.capacitorlab.CLPaints;
import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.awt.Color;

public abstract class DielectricMaterial {
    private final String name;
    private final Color color;
    private final Property<Double> dielectricConstantProperty;

    public DielectricMaterial(String string, double d, Color color) {
        this.name = string;
        this.dielectricConstantProperty = new Property<Double>(d);
        this.color = color;
    }

    public void reset() {
        this.dielectricConstantProperty.reset();
    }

    public String getName() {
        return this.name;
    }

    public double getDielectricConstant() {
        return this.dielectricConstantProperty.get();
    }

    protected void setDielectricConstant(double d) {
        this.dielectricConstantProperty.set(d);
    }

    public void addDielectricConstantObserver(SimpleObserver simpleObserver) {
        this.dielectricConstantProperty.addObserver(simpleObserver);
    }

    public void removeDielectricConstantObserver(SimpleObserver simpleObserver) {
        this.dielectricConstantProperty.removeObserver(simpleObserver);
    }

    public Color getColor() {
        return this.color;
    }

    public static class Air
    extends DielectricMaterial {
        public Air() {
            super("air", 1.0, CLPaints.AIR);
        }
    }

    public static class CustomDielectricMaterial
    extends DielectricMaterial {
        public CustomDielectricMaterial() {
            this(CLConstants.DIELECTRIC_CONSTANT_RANGE.getDefault());
        }

        public CustomDielectricMaterial(double d) {
            super(CLStrings.CUSTOM, d, CLPaints.CUSTOM_DIELECTRIC);
        }

        public void setDielectricConstant(double d) {
            super.setDielectricConstant(d);
        }
    }

    public static class Glass
    extends DielectricMaterial {
        public Glass() {
            super(CLStrings.GLASS, 4.7, CLPaints.GLASS);
        }
    }

    public static class Paper
    extends DielectricMaterial {
        public Paper() {
            super(CLStrings.PAPER, 3.5, CLPaints.PAPER);
        }
    }

    public static class Teflon
    extends DielectricMaterial {
        public Teflon() {
            super(CLStrings.TEFLON, 2.1, CLPaints.TEFLON);
        }
    }
}

