/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.model.circuit;

import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.capacitorlab.model.Battery;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.model.CircuitConfig;
import edu.colorado.phet.capacitorlab.model.circuit.AbstractCircuit;
import edu.colorado.phet.capacitorlab.model.wire.Wire;
import edu.colorado.phet.capacitorlab.model.wire.WireBatteryToCapacitors;
import edu.colorado.phet.capacitorlab.model.wire.WireCapacitorToCapacitors;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import java.awt.Shape;
import java.util.ArrayList;

public class Combination2Circuit
extends AbstractCircuit {
    private final Capacitor c1 = this.getCapacitors().get(0);
    private final Capacitor c2 = this.getCapacitors().get(1);
    private final Capacitor c3 = this.getCapacitors().get(2);

    public Combination2Circuit(CircuitConfig circuitConfig) {
        super(circuitConfig, CLStrings.COMBINATION_2, 3, new AbstractCircuit.CreateCapacitors(){

            @Override
            public ArrayList<Capacitor> apply(CircuitConfig circuitConfig, Integer n) {
                double d = circuitConfig.batteryLocation.getX() + circuitConfig.capacitorXSpacing;
                double d2 = circuitConfig.batteryLocation.getY() - 0.5 * circuitConfig.capacitorYSpacing;
                double d3 = circuitConfig.batteryLocation.getZ();
                final Capacitor capacitor = new Capacitor(new Point3D.Double(d, d2, d3), circuitConfig.plateWidth, circuitConfig.plateSeparation, circuitConfig.dielectricMaterial, circuitConfig.dielectricOffset, circuitConfig.mvt);
                final Capacitor capacitor2 = new Capacitor(new Point3D.Double(d, d2 += circuitConfig.capacitorYSpacing, d3), circuitConfig.plateWidth, circuitConfig.plateSeparation, circuitConfig.dielectricMaterial, circuitConfig.dielectricOffset, circuitConfig.mvt);
                final Capacitor capacitor3 = new Capacitor(new Point3D.Double(d += circuitConfig.capacitorXSpacing, d2, d3), circuitConfig.plateWidth, circuitConfig.plateSeparation, circuitConfig.dielectricMaterial, circuitConfig.dielectricOffset, circuitConfig.mvt);
                return new ArrayList<Capacitor>(){
                    {
                        this.add(capacitor);
                        this.add(capacitor2);
                        this.add(capacitor3);
                    }
                };
            }
        }, new AbstractCircuit.CreateWires(){

            @Override
            public ArrayList<Wire> apply(final CircuitConfig circuitConfig, final Battery battery, ArrayList<Capacitor> arrayList) {
                final Capacitor capacitor = arrayList.get(0);
                final Capacitor capacitor2 = arrayList.get(1);
                final Capacitor capacitor3 = arrayList.get(2);
                return new ArrayList<Wire>(){
                    {
                        this.add(new WireBatteryToCapacitors.WireBatteryToCapacitorsTop(circuitConfig.mvt, 5.0E-4, circuitConfig.wireExtent, battery, capacitor));
                        this.add(new WireCapacitorToCapacitors(circuitConfig.mvt, 5.0E-4, capacitor, capacitor2, capacitor3));
                        this.add(new WireBatteryToCapacitors.WireBatteryToCapacitorsBottom(circuitConfig.mvt, 5.0E-4, circuitConfig.wireExtent, battery, capacitor2, capacitor3));
                    }
                };
            }
        });
        this.updatePlateVoltages();
    }

    protected void updatePlateVoltages() {
        double d = this.getTotalCharge();
        this.c1.setPlatesVoltage(d / this.c1.getTotalCapacitance());
        double d2 = d / (this.c2.getTotalCapacitance() + this.c3.getTotalCapacitance());
        this.c2.setPlatesVoltage(d2);
        this.c3.setPlatesVoltage(d2);
    }

    private Wire getMiddleWire() {
        return this.getWires().get(1);
    }

    public double getTotalCapacitance() {
        double d = this.c1.getTotalCapacitance();
        double d2 = this.c2.getTotalCapacitance();
        double d3 = this.c3.getTotalCapacitance();
        return 1.0 / (1.0 / d + 1.0 / (d2 + d3));
    }

    public double getVoltageAt(Shape shape) {
        double d = Double.NaN;
        if (this.connectedToBatteryTop(shape)) {
            d = this.getTotalVoltage();
        } else if (this.connectedToBatteryBottom(shape)) {
            d = 0.0;
        } else if (this.connectedToC2TopPlate(shape)) {
            d = this.c2.getPlatesVoltage();
        }
        return d;
    }

    private boolean connectedToBatteryTop(Shape shape) {
        return this.getBattery().intersectsTopTerminal(shape) || this.getTopWire().intersects(shape) || this.c1.intersectsTopPlate(shape);
    }

    private boolean connectedToBatteryBottom(Shape shape) {
        return this.getBattery().intersectsBottomTerminal(shape) || this.getBottomWire().intersects(shape) || this.c2.intersectsBottomPlate(shape) || this.c3.intersectsBottomPlate(shape);
    }

    private boolean connectedToC2TopPlate(Shape shape) {
        return this.c1.intersectsBottomPlate(shape) || this.getMiddleWire().intersects(shape) || this.c2.intersectsTopPlate(shape) || this.c3.intersectsTopPlate(shape);
    }
}

