/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.model.meter;

import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.WorldBounds;
import edu.colorado.phet.capacitorlab.model.WorldLocationProperty;
import edu.colorado.phet.capacitorlab.model.circuit.ICircuit;
import edu.colorado.phet.capacitorlab.shapes.VoltmeterShapeCreator;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.ShapeUtils;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Dimension2D;

public class Voltmeter {
    private final PDimension PROBE_TIP_SIZE = new PDimension(5.0E-4, 0.0015);
    private final VoltmeterShapeCreator shapeCreator;
    public final Property<Boolean> visibleProperty;
    public final WorldLocationProperty bodyLocationProperty;
    public final WorldLocationProperty positiveProbeLocationProperty;
    public final WorldLocationProperty negativeProbeLocationProperty;
    private final Property<Double> valueProperty;
    private ICircuit circuit;
    private final ICircuit.CircuitChangeListener circuitChangeListener;

    public Voltmeter(ICircuit iCircuit, WorldBounds worldBounds, CLModelViewTransform3D cLModelViewTransform3D, Point3D point3D, Point3D point3D2, Point3D point3D3, boolean bl) {
        this.circuit = iCircuit;
        this.circuitChangeListener = new ICircuit.CircuitChangeListener(){

            public void circuitChanged() {
                Voltmeter.this.updateValue();
            }
        };
        iCircuit.addCircuitChangeListener(this.circuitChangeListener);
        this.shapeCreator = new VoltmeterShapeCreator(this, cLModelViewTransform3D);
        this.visibleProperty = new Property<Boolean>(bl);
        this.bodyLocationProperty = new WorldLocationProperty(worldBounds, point3D);
        this.positiveProbeLocationProperty = new WorldLocationProperty(worldBounds, point3D2);
        this.negativeProbeLocationProperty = new WorldLocationProperty(worldBounds, point3D3);
        this.valueProperty = new Property<Double>(0.0);
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                Voltmeter.this.updateValue();
            }
        };
        richSimpleObserver.observe(this.positiveProbeLocationProperty, this.negativeProbeLocationProperty);
    }

    private void updateValue() {
        if (this.probesAreTouching()) {
            this.valueProperty.set(0.0);
        } else {
            this.valueProperty.set(this.circuit.getVoltageBetween(this.shapeCreator.getPositiveProbeTipShape(), this.shapeCreator.getNegativeProbeTipShape()));
        }
    }

    private boolean probesAreTouching() {
        return ShapeUtils.intersects(this.shapeCreator.getPositiveProbeTipShape(), this.shapeCreator.getNegativeProbeTipShape());
    }

    public void reset() {
        this.visibleProperty.reset();
        this.bodyLocationProperty.reset();
        this.positiveProbeLocationProperty.reset();
        this.negativeProbeLocationProperty.reset();
    }

    public void setCircuit(ICircuit iCircuit) {
        if (iCircuit != this.circuit) {
            this.circuit.removeCircuitChangeListener(this.circuitChangeListener);
            this.circuit = iCircuit;
            this.circuit.addCircuitChangeListener(this.circuitChangeListener);
            this.updateValue();
        }
    }

    public boolean isVisible() {
        return this.visibleProperty.get();
    }

    public double getValue() {
        return this.valueProperty.get();
    }

    public void addValueObserver(SimpleObserver simpleObserver) {
        this.valueProperty.addObserver(simpleObserver);
    }

    public VoltmeterShapeCreator getShapeCreator() {
        return this.shapeCreator;
    }

    public Dimension2D getProbeTipSizeReference() {
        return this.PROBE_TIP_SIZE;
    }
}

