/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.model.wire;

import edu.colorado.phet.capacitorlab.model.Battery;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.model.wire.Wire;
import edu.colorado.phet.capacitorlab.model.wire.WireSegment;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.ShapeUtils;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WireBatteryToCapacitors
extends Wire {
    public WireBatteryToCapacitors(ConnectionPoint connectionPoint, CLModelViewTransform3D cLModelViewTransform3D, double d, double d2, Battery battery, ArrayList<Capacitor> arrayList) {
        super(cLModelViewTransform3D, d);
        double d3 = WireBatteryToCapacitors.getHorizontalY(connectionPoint, arrayList, d2);
        Capacitor capacitor = arrayList.get(arrayList.size() - 1);
        Point2D.Double double_ = new Point2D.Double(battery.getX(), d3);
        Point2D.Double double_2 = new Point2D.Double(capacitor.getX(), double_.getY());
        double d4 = this.getCornerOffset();
        this.addSegment(WireBatteryToCapacitors.getBatteryWireSegment(connectionPoint, battery, this.getEndOffset(), double_));
        this.addSegment(new WireSegment(double_.getX() - d4, double_.getY() + d4, double_2.getX() + d4, double_2.getY() + d4));
        this.addSegment(WireBatteryToCapacitors.getCapacitorWireSegment(connectionPoint, capacitor, double_2));
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            Capacitor capacitor2 = arrayList.get(i);
            Point2D.Double double_3 = new Point2D.Double(capacitor2.getX(), d3);
            this.addSegment(WireBatteryToCapacitors.getCapacitorWireSegment(connectionPoint, capacitor2, double_3));
        }
    }

    private static double getHorizontalY(ConnectionPoint connectionPoint, ArrayList<Capacitor> arrayList, double d) {
        double d2 = arrayList.get(0).getY();
        if (connectionPoint == ConnectionPoint.TOP) {
            for (Capacitor capacitor : arrayList) {
                d2 = Math.min(d2, capacitor.getLocation().getY() - d);
            }
        } else {
            for (Capacitor capacitor : arrayList) {
                d2 = Math.max(d2, capacitor.getLocation().getY() + d);
            }
        }
        return d2;
    }

    private static WireSegment getBatteryWireSegment(ConnectionPoint connectionPoint, Battery battery, double d, Point2D point2D) {
        if (connectionPoint == ConnectionPoint.TOP) {
            return new WireSegment.BatteryTopWireSegment(battery, d, point2D);
        }
        return new WireSegment.BatteryBottomWireSegment(battery, d, point2D);
    }

    private static WireSegment getCapacitorWireSegment(ConnectionPoint connectionPoint, Capacitor capacitor, Point2D point2D) {
        if (connectionPoint == ConnectionPoint.TOP) {
            return new WireSegment.CapacitorTopWireSegment(capacitor, point2D);
        }
        return new WireSegment.CapacitorBottomWireSegment(capacitor, point2D);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConnectionPoint
    extends Enum<ConnectionPoint> {
        public static final /* enum */ ConnectionPoint TOP = new ConnectionPoint();
        public static final /* enum */ ConnectionPoint BOTTOM = new ConnectionPoint();
        private static final /* synthetic */ ConnectionPoint[] $VALUES;

        public static ConnectionPoint[] values() {
            return (ConnectionPoint[])$VALUES.clone();
        }

        static {
            $VALUES = new ConnectionPoint[]{TOP, BOTTOM};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WireBatteryToCapacitorsBottom
    extends WireBatteryToCapacitors {
        private final Battery battery;
        private final ArrayList<Capacitor> capacitors;

        public WireBatteryToCapacitorsBottom(CLModelViewTransform3D cLModelViewTransform3D, double d, double d2, Battery battery, Capacitor ... capacitorArray) {
            this(cLModelViewTransform3D, d, d2, battery, new ArrayList<Capacitor>(Arrays.asList(capacitorArray)));
        }

        public WireBatteryToCapacitorsBottom(CLModelViewTransform3D cLModelViewTransform3D, double d, double d2, Battery battery, ArrayList<Capacitor> arrayList) {
            super(ConnectionPoint.BOTTOM, cLModelViewTransform3D, d, d2, battery, arrayList);
            this.battery = battery;
            this.capacitors = arrayList;
            SimpleObserver simpleObserver = new SimpleObserver(){

                public void update() {
                    WireBatteryToCapacitorsBottom.this.setShape(WireBatteryToCapacitorsBottom.this.createShape());
                }
            };
            for (Capacitor capacitor : arrayList) {
                capacitor.addPlateSizeObserver(simpleObserver, false);
            }
            this.setShape(this.createShape());
        }

        @Override
        protected Shape createShape() {
            Shape shape = super.createShape();
            if (this.battery != null && this.capacitors != null) {
                shape = ShapeUtils.subtract(shape, this.battery.getShapeCreator().createBodyShape());
                for (Capacitor capacitor : this.capacitors) {
                    shape = ShapeUtils.subtract(shape, capacitor.getShapeCreator().createBottomPlateShape());
                }
            }
            return shape;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WireBatteryToCapacitorsTop
    extends WireBatteryToCapacitors {
        public WireBatteryToCapacitorsTop(CLModelViewTransform3D cLModelViewTransform3D, double d, double d2, Battery battery, Capacitor ... capacitorArray) {
            this(cLModelViewTransform3D, d, d2, battery, new ArrayList<Capacitor>(Arrays.asList(capacitorArray)));
        }

        public WireBatteryToCapacitorsTop(CLModelViewTransform3D cLModelViewTransform3D, double d, double d2, Battery battery, ArrayList<Capacitor> arrayList) {
            super(ConnectionPoint.TOP, cLModelViewTransform3D, d, d2, battery, arrayList);
        }
    }
}

