/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.module.dielectric;

import edu.colorado.phet.capacitorlab.CLGlobalProperties;
import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.capacitorlab.developer.EFieldShapesDebugNode;
import edu.colorado.phet.capacitorlab.developer.VoltageShapesDebugNode;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.DielectricChargeView;
import edu.colorado.phet.capacitorlab.module.CLCanvas;
import edu.colorado.phet.capacitorlab.module.dielectric.DielectricModel;
import edu.colorado.phet.capacitorlab.view.DielectricCircuitNode;
import edu.colorado.phet.capacitorlab.view.meters.BarMeterNode;
import edu.colorado.phet.capacitorlab.view.meters.EFieldDetectorNode;
import edu.colorado.phet.capacitorlab.view.meters.VoltmeterNode;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.nodes.PComposite;

public class DielectricCanvas
extends CLCanvas {
    private final DielectricModel model;
    private final BarMeterNode capacitanceMeterNode;
    private final BarMeterNode plateChargeMeterNode;
    private final BarMeterNode storedEnergyMeterNode;
    private final PNode shapesDebugParentNode;

    public DielectricCanvas(final DielectricModel dielectricModel, CLModelViewTransform3D cLModelViewTransform3D, CLGlobalProperties cLGlobalProperties, boolean bl, boolean bl2) {
        super(dielectricModel, cLModelViewTransform3D, cLGlobalProperties);
        this.model = dielectricModel;
        double d = DielectricModel.getMaxPlateCharge();
        double d2 = DielectricModel.getMaxExcessDielectricPlateCharge();
        double d3 = DielectricModel.getMaxEffectiveEField();
        double d4 = DielectricModel.getMaxDielectricEField();
        double d5 = DielectricModel.getEFieldReferenceMagnitude();
        final DielectricCircuitNode dielectricCircuitNode = new DielectricCircuitNode(dielectricModel.circuit, cLModelViewTransform3D, bl2, this.getPlateChargesVisibleProperty(), this.getEFieldVisibleProperty(), this.getDielectricChargeViewProperty(), d, d2, d3, d4);
        this.capacitanceMeterNode = new BarMeterNode.CapacitanceMeterNode(dielectricModel.capacitanceMeter, cLModelViewTransform3D, CLStrings.CAPACITANCE);
        this.plateChargeMeterNode = new BarMeterNode.PlateChargeMeterNode(dielectricModel.plateChargeMeter, cLModelViewTransform3D, CLStrings.PLATE_CHARGE_TOP);
        this.storedEnergyMeterNode = new BarMeterNode.StoredEnergyMeterNode(dielectricModel.storedEnergyMeter, cLModelViewTransform3D, CLStrings.STORED_ENERGY);
        VoltmeterNode voltmeterNode = new VoltmeterNode(dielectricModel.voltmeter, cLModelViewTransform3D);
        EFieldDetectorNode eFieldDetectorNode = new EFieldDetectorNode(dielectricModel.eFieldDetector, cLModelViewTransform3D, d5, cLGlobalProperties.dev, bl);
        this.shapesDebugParentNode = new PComposite();
        this.addChild(dielectricCircuitNode);
        this.addChild(this.capacitanceMeterNode);
        this.addChild(this.plateChargeMeterNode);
        this.addChild(this.storedEnergyMeterNode);
        this.addChild(eFieldDetectorNode);
        this.addChild(voltmeterNode);
        this.addChild(this.shapesDebugParentNode);
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                boolean bl = DielectricCanvas.this.getEFieldVisibleProperty().get() != false || dielectricModel.voltmeter.isVisible() || dielectricModel.eFieldDetector.visibleProperty.get() != false || DielectricCanvas.this.getDielectricChargeViewProperty().get() == DielectricChargeView.EXCESS;
                dielectricCircuitNode.setDielectricTransparent(bl);
            }
        };
        richSimpleObserver.observe(this.getEFieldVisibleProperty(), dielectricModel.voltmeter.visibleProperty, dielectricModel.eFieldDetector.visibleProperty, this.getDielectricChargeViewProperty());
        RichSimpleObserver richSimpleObserver2 = new RichSimpleObserver(){

            public void update() {
                DielectricCanvas.this.updateShapesDebugNodes();
            }
        };
        richSimpleObserver2.observe(cLGlobalProperties.eFieldShapesVisibleProperty, cLGlobalProperties.voltageShapesVisibleProperty);
        this.reset();
    }

    public void reset() {
        super.reset();
        this.capacitanceMeterNode.reset();
        this.plateChargeMeterNode.reset();
        this.storedEnergyMeterNode.reset();
    }

    private void updateShapesDebugNodes() {
        this.shapesDebugParentNode.removeAllChildren();
        VoltageShapesDebugNode voltageShapesDebugNode = new VoltageShapesDebugNode(this.model.circuit, this.model.voltmeter);
        this.shapesDebugParentNode.addChild(voltageShapesDebugNode);
        voltageShapesDebugNode.setVisible(this.getGlobalProperties().voltageShapesVisibleProperty.get());
        EFieldShapesDebugNode eFieldShapesDebugNode = new EFieldShapesDebugNode(this.model.circuit);
        this.shapesDebugParentNode.addChild(eFieldShapesDebugNode);
        eFieldShapesDebugNode.setVisible(this.getGlobalProperties().eFieldShapesVisibleProperty.get());
    }
}

