/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.module.multiplecapacitors;

import edu.colorado.phet.capacitorlab.CLGlobalProperties;
import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.capacitorlab.developer.EFieldShapesDebugNode;
import edu.colorado.phet.capacitorlab.developer.VoltageShapesDebugNode;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.circuit.ICircuit;
import edu.colorado.phet.capacitorlab.module.CLCanvas;
import edu.colorado.phet.capacitorlab.module.dielectric.DielectricModel;
import edu.colorado.phet.capacitorlab.module.multiplecapacitors.MultipleCapacitorsModel;
import edu.colorado.phet.capacitorlab.view.MultipleCapacitorsCircuitNode;
import edu.colorado.phet.capacitorlab.view.meters.BarMeterNode;
import edu.colorado.phet.capacitorlab.view.meters.EFieldDetectorNode;
import edu.colorado.phet.capacitorlab.view.meters.VoltmeterNode;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.nodes.PComposite;

public class MultipleCapacitorsCanvas
extends CLCanvas {
    private final MultipleCapacitorsModel model;
    private final PNode circuitParentNode;
    private final BarMeterNode capacitanceMeterNode;
    private final BarMeterNode plateChargeMeterNode;
    private final BarMeterNode storedEnergyMeterNode;
    private final PNode shapesDebugParentNode;

    public MultipleCapacitorsCanvas(MultipleCapacitorsModel multipleCapacitorsModel, CLModelViewTransform3D cLModelViewTransform3D, CLGlobalProperties cLGlobalProperties) {
        super(multipleCapacitorsModel, cLModelViewTransform3D, cLGlobalProperties);
        Object object;
        this.model = multipleCapacitorsModel;
        double d = DielectricModel.getMaxPlateCharge();
        double d2 = DielectricModel.getMaxExcessDielectricPlateCharge();
        double d3 = DielectricModel.getMaxEffectiveEField();
        double d4 = DielectricModel.getMaxDielectricEField();
        double d5 = MultipleCapacitorsModel.getEFieldReferenceMagnitude();
        this.circuitParentNode = new PNode();
        for (ICircuit object22 : multipleCapacitorsModel.getCircuits()) {
            object = new MultipleCapacitorsCircuitNode(object22, cLModelViewTransform3D, false, this.getPlateChargesVisibleProperty(), this.getEFieldVisibleProperty(), this.getDielectricChargeViewProperty(), d, d2, d3, d4);
            ((PNode)object).setVisible(false);
            this.circuitParentNode.addChild((PNode)object);
        }
        this.capacitanceMeterNode = new BarMeterNode.CapacitanceMeterNode(multipleCapacitorsModel.capacitanceMeter, cLModelViewTransform3D, CLStrings.TOTAL_CAPACITANCE);
        this.plateChargeMeterNode = new BarMeterNode.PlateChargeMeterNode(multipleCapacitorsModel.plateChargeMeter, cLModelViewTransform3D, CLStrings.STORED_CHARGE);
        this.storedEnergyMeterNode = new BarMeterNode.StoredEnergyMeterNode(multipleCapacitorsModel.storedEnergyMeter, cLModelViewTransform3D, CLStrings.STORED_ENERGY);
        VoltmeterNode voltmeterNode = new VoltmeterNode(multipleCapacitorsModel.voltmeter, cLModelViewTransform3D);
        EFieldDetectorNode eFieldDetectorNode = new EFieldDetectorNode(multipleCapacitorsModel.eFieldDetector, cLModelViewTransform3D, d5, cLGlobalProperties.dev, true);
        this.shapesDebugParentNode = new PComposite();
        this.addChild(this.circuitParentNode);
        this.addChild(this.capacitanceMeterNode);
        this.addChild(this.plateChargeMeterNode);
        this.addChild(this.storedEnergyMeterNode);
        this.addChild(eFieldDetectorNode);
        this.addChild(voltmeterNode);
        this.addChild(this.shapesDebugParentNode);
        multipleCapacitorsModel.currentCircuitProperty.addObserver(new SimpleObserver(){

            public void update() {
                MultipleCapacitorsCanvas.this.updateCircuitNodes();
            }
        });
        object = new RichSimpleObserver(){

            public void update() {
                MultipleCapacitorsCanvas.this.updateShapesDebugNodes();
            }
        };
        ((RichSimpleObserver)object).observe(cLGlobalProperties.eFieldShapesVisibleProperty, cLGlobalProperties.voltageShapesVisibleProperty);
    }

    public void reset() {
        super.reset();
        this.capacitanceMeterNode.reset();
        this.plateChargeMeterNode.reset();
        this.storedEnergyMeterNode.reset();
    }

    private void updateCircuitNodes() {
        int n = this.circuitParentNode.getChildrenCount();
        for (int i = 0; i < n; ++i) {
            PNode pNode = this.circuitParentNode.getChild(i);
            if (!(pNode instanceof MultipleCapacitorsCircuitNode)) continue;
            MultipleCapacitorsCircuitNode multipleCapacitorsCircuitNode = (MultipleCapacitorsCircuitNode)pNode;
            multipleCapacitorsCircuitNode.setVisible(this.model.currentCircuitProperty.get() == multipleCapacitorsCircuitNode.getCircuit());
        }
        this.updateShapesDebugNodes();
    }

    private void updateShapesDebugNodes() {
        this.shapesDebugParentNode.removeAllChildren();
        VoltageShapesDebugNode voltageShapesDebugNode = new VoltageShapesDebugNode(this.model.currentCircuitProperty.get(), this.model.voltmeter);
        this.shapesDebugParentNode.addChild(voltageShapesDebugNode);
        voltageShapesDebugNode.setVisible(this.getGlobalProperties().voltageShapesVisibleProperty.get());
        EFieldShapesDebugNode eFieldShapesDebugNode = new EFieldShapesDebugNode(this.model.currentCircuitProperty.get());
        this.shapesDebugParentNode.addChild(eFieldShapesDebugNode);
        eFieldShapesDebugNode.setVisible(this.getGlobalProperties().eFieldShapesVisibleProperty.get());
    }
}

