/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.shapes;

import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.meter.Voltmeter;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class VoltmeterShapeCreator {
    private final Voltmeter voltmeter;
    private final CLModelViewTransform3D mvt;

    public VoltmeterShapeCreator(Voltmeter voltmeter, CLModelViewTransform3D cLModelViewTransform3D) {
        this.voltmeter = voltmeter;
        this.mvt = cLModelViewTransform3D;
    }

    public Shape getPositiveProbeTipShape() {
        return this.getProbeTipShape((Point3D)this.voltmeter.positiveProbeLocationProperty.get(), -this.mvt.getYaw());
    }

    public Shape getNegativeProbeTipShape() {
        return this.getProbeTipShape((Point3D)this.voltmeter.negativeProbeLocationProperty.get(), -this.mvt.getYaw());
    }

    private Shape getProbeTipShape(Point3D point3D, double d) {
        double d2 = this.voltmeter.getProbeTipSizeReference().getWidth();
        double d3 = this.voltmeter.getProbeTipSizeReference().getHeight();
        double d4 = point3D.getX() - d2 / 2.0;
        double d5 = point3D.getY();
        Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d5, d2, d3);
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d, point3D.getX(), point3D.getY());
        Shape shape = affineTransform.createTransformedShape(double_);
        return this.mvt.modelToView(shape);
    }
}

