/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view;

import edu.colorado.phet.capacitorlab.CLImages;
import edu.colorado.phet.capacitorlab.control.VoltageSliderNode;
import edu.colorado.phet.capacitorlab.model.Battery;
import edu.colorado.phet.capacitorlab.model.Polarity;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.umd.cs.piccolo.nodes.PImage;

public class BatteryNode
extends PhetPNode {
    public BatteryNode(final Battery battery, DoubleRange doubleRange) {
        final PImage pImage = new PImage(CLImages.BATTERY_UP);
        this.addChild(pImage);
        double d = 0.6 * pImage.getFullBoundsReference().getHeight();
        VoltageSliderNode voltageSliderNode = new VoltageSliderNode(battery, doubleRange, d);
        this.addChild(voltageSliderNode);
        double d2 = -pImage.getFullBoundsReference().getWidth() / 2.0;
        double d3 = -pImage.getFullBoundsReference().getHeight() / 2.0;
        pImage.setOffset(d2, d3);
        d2 = pImage.getXOffset() + (pImage.getFullBoundsReference().getWidth() - voltageSliderNode.getFullBoundsReference().getWidth()) / 2.0 + 5.0;
        d3 = pImage.getYOffset() + 53.0;
        voltageSliderNode.setOffset(d2, d3);
        battery.addPolarityObserver(new SimpleObserver(){

            public void update() {
                if (battery.getPolarity() == Polarity.POSITIVE) {
                    pImage.setImage(CLImages.BATTERY_UP);
                } else {
                    pImage.setImage(CLImages.BATTERY_DOWN);
                }
            }
        });
    }
}

