/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view;

import edu.colorado.phet.capacitorlab.model.circuit.ICircuit;
import edu.colorado.phet.capacitorlab.view.MinusNode;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.RoundGradientPaint;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.activities.FadeOutActivity;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.common.piccolophet.nodes.SphericalNode;
import edu.umd.cs.piccolo.activities.PActivity;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class CurrentIndicatorNode
extends PhetPNode {
    private static final Point2D ARROW_TIP_LOCATION = new Point2D.Double(0.0, 0.0);
    private static final Point2D ARROW_TAIL_LOCATION = new Point2D.Double(175.0, 0.0);
    private static final Color ARROW_COLOR = new Color(83, 200, 236);
    private static final Paint ELECTRON_FILL_COLOR = new RoundGradientPaint(0.0, 0.0, Color.WHITE, new Point2D.Double(4.800000000000001, 4.800000000000001), ARROW_COLOR);
    private static final Stroke ELECTRON_STROKE = new BasicStroke(1.0f);
    private static final Color ELECTRON_STROKE_COLOR = Color.BLACK;
    private static final Color ELECTRON_MINUS_COLOR = Color.BLACK;
    private final ICircuit circuit;
    private final double positiveOrientation;
    private PActivity fadeOutActivity;

    public CurrentIndicatorNode(ICircuit iCircuit, double d) {
        this.circuit = iCircuit;
        this.positiveOrientation = d;
        ArrowNode arrowNode = new ArrowNode(ARROW_TAIL_LOCATION, ARROW_TIP_LOCATION, 50.0, 60.0, 24.0);
        arrowNode.setPaint(ARROW_COLOR);
        this.addChild(arrowNode);
        SphericalNode sphericalNode = new SphericalNode(19.200000000000003, ELECTRON_FILL_COLOR, false);
        sphericalNode.setStroke(ELECTRON_STROKE);
        sphericalNode.setStrokePaint(ELECTRON_STROKE_COLOR);
        this.addChild(sphericalNode);
        MinusNode minusNode = new MinusNode(11.520000000000001, 1.9200000000000004, ELECTRON_MINUS_COLOR);
        this.addChild(minusNode);
        double d2 = -arrowNode.getFullBoundsReference().getWidth() / 2.0;
        double d3 = 0.0;
        arrowNode.setOffset(d2, d3);
        d2 = arrowNode.getFullBoundsReference().getMaxX() - 0.6 * (arrowNode.getFullBoundsReference().getWidth() - 50.0);
        d3 = arrowNode.getFullBoundsReference().getCenterY();
        sphericalNode.setOffset(d2, d3);
        d2 = sphericalNode.getFullBoundsReference().getCenterX();
        d3 = sphericalNode.getFullBoundsReference().getCenterY();
        minusNode.setOffset(d2, d3);
        iCircuit.addCurrentAmplitudeObserver(new SimpleObserver(){

            public void update() {
                if (CurrentIndicatorNode.this.isVisible()) {
                    CurrentIndicatorNode.this.updateTransparency();
                    CurrentIndicatorNode.this.updateOrientation();
                }
            }
        });
    }

    private void updateTransparency() {
        double d;
        if (this.fadeOutActivity != null) {
            this.fadeOutActivity.terminate(0);
            this.fadeOutActivity = null;
        }
        if ((d = this.circuit.getCurrentAmplitude()) != 0.0) {
            this.setTransparency(0.75f);
        } else if (this.getRoot() == null) {
            this.setTransparency(0.0f);
        } else {
            this.fadeOutActivity = new FadeOutActivity(this, 500L, 10L);
            this.fadeOutActivity.setDelegate(new PActivity.PActivityDelegate(){

                public void activityFinished(PActivity pActivity) {
                    CurrentIndicatorNode.this.fadeOutActivity = null;
                }

                public void activityStarted(PActivity pActivity) {
                }

                public void activityStepped(PActivity pActivity) {
                }
            });
            this.getRoot().addActivity(this.fadeOutActivity);
        }
    }

    private void updateOrientation() {
        double d = this.circuit.getCurrentAmplitude();
        if (d != 0.0) {
            this.setRotation(this.circuit.getCurrentAmplitude() > 0.0 ? this.positiveOrientation : this.positiveOrientation + Math.PI);
        }
    }
}

