/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view;

import edu.colorado.phet.capacitorlab.CLConstants;
import edu.colorado.phet.capacitorlab.control.BatteryConnectionButtonNode;
import edu.colorado.phet.capacitorlab.control.PlateChargeControlNode;
import edu.colorado.phet.capacitorlab.drag.DielectricOffsetDragHandleNode;
import edu.colorado.phet.capacitorlab.drag.DielectricOffsetDragHandler;
import edu.colorado.phet.capacitorlab.drag.PlateAreaDragHandleNode;
import edu.colorado.phet.capacitorlab.drag.PlateSeparationDragHandleNode;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.DielectricChargeView;
import edu.colorado.phet.capacitorlab.model.circuit.ICircuit;
import edu.colorado.phet.capacitorlab.model.circuit.SingleCircuit;
import edu.colorado.phet.capacitorlab.view.BatteryNode;
import edu.colorado.phet.capacitorlab.view.CapacitorNode;
import edu.colorado.phet.capacitorlab.view.CurrentIndicatorNode;
import edu.colorado.phet.capacitorlab.view.WireNode;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DielectricCircuitNode
extends PhetPNode {
    private final SingleCircuit circuit;
    private final CapacitorNode capacitorNode;
    private final WireNode topWireNode;
    private final WireNode bottomWireNode;
    private final CurrentIndicatorNode topCurrentIndicatorNode;
    private final CurrentIndicatorNode bottomCurrentIndicatorNode;
    private final PlateChargeControlNode plateChargeControlNode;

    public DielectricCircuitNode(final SingleCircuit singleCircuit, final CLModelViewTransform3D cLModelViewTransform3D, final boolean bl, Property<Boolean> property, Property<Boolean> property2, Property<DielectricChargeView> property3, double d, double d2, double d3, double d4) {
        this.circuit = singleCircuit;
        BatteryNode batteryNode = new BatteryNode(singleCircuit.getBattery(), CLConstants.BATTERY_VOLTAGE_RANGE);
        this.capacitorNode = new CapacitorNode(singleCircuit.getCapacitor(), cLModelViewTransform3D, bl, property, property2, property3, d, d2, d3, d4){
            {
                super(capacitor, cLModelViewTransform3D3, bl3, property, property2, property3, d, d2, d3, d4);
                if (bl) {
                    this.getDielectricNode().addInputEventListener(new CursorHandler(11));
                    this.getDielectricNode().addInputEventListener(new DielectricOffsetDragHandler(this, singleCircuit.getCapacitor(), cLModelViewTransform3D, CLConstants.DIELECTRIC_OFFSET_RANGE));
                } else {
                    this.getDielectricNode().setVisible(false);
                }
            }
        };
        this.topWireNode = new WireNode(singleCircuit.getTopWire());
        this.bottomWireNode = new WireNode(singleCircuit.getBottomWire());
        DielectricOffsetDragHandleNode dielectricOffsetDragHandleNode = new DielectricOffsetDragHandleNode(singleCircuit.getCapacitor(), cLModelViewTransform3D, CLConstants.DIELECTRIC_OFFSET_RANGE);
        PlateSeparationDragHandleNode plateSeparationDragHandleNode = new PlateSeparationDragHandleNode(singleCircuit.getCapacitor(), cLModelViewTransform3D, CLConstants.PLATE_SEPARATION_RANGE);
        PlateAreaDragHandleNode plateAreaDragHandleNode = new PlateAreaDragHandleNode(singleCircuit.getCapacitor(), cLModelViewTransform3D, CLConstants.PLATE_WIDTH_RANGE);
        this.topCurrentIndicatorNode = new CurrentIndicatorNode(singleCircuit, 0.0);
        this.bottomCurrentIndicatorNode = new CurrentIndicatorNode(singleCircuit, Math.PI);
        BatteryConnectionButtonNode batteryConnectionButtonNode = new BatteryConnectionButtonNode(singleCircuit);
        this.plateChargeControlNode = new PlateChargeControlNode(singleCircuit, new DoubleRange(-d, d));
        this.addChild(this.bottomWireNode);
        this.addChild(batteryNode);
        this.addChild(this.capacitorNode);
        this.addChild(this.topWireNode);
        this.addChild(this.topCurrentIndicatorNode);
        this.addChild(this.bottomCurrentIndicatorNode);
        if (bl) {
            this.addChild(dielectricOffsetDragHandleNode);
        }
        this.addChild(plateSeparationDragHandleNode);
        this.addChild(plateAreaDragHandleNode);
        this.addChild(batteryConnectionButtonNode);
        this.addChild(this.plateChargeControlNode);
        this.topWireNode.setOffset(0.0, 0.0);
        this.bottomWireNode.setOffset(0.0, 0.0);
        batteryNode.setOffset(cLModelViewTransform3D.modelToView(singleCircuit.getBattery().getLocationReference()));
        this.capacitorNode.setOffset(cLModelViewTransform3D.modelToView(singleCircuit.getCapacitor().getLocation()));
        double d5 = cLModelViewTransform3D.modelToViewDelta(singleCircuit.getTopWire().getThickness(), 0.0, 0.0).getX();
        double d6 = this.topWireNode.getFullBoundsReference().getCenterX();
        double d7 = this.topWireNode.getFullBoundsReference().getMinY() + d5 / 2.0;
        this.topCurrentIndicatorNode.setOffset(d6, d7);
        double d8 = cLModelViewTransform3D.modelToViewDelta(singleCircuit.getBottomWire().getThickness(), 0.0, 0.0).getX();
        d6 = this.bottomWireNode.getFullBoundsReference().getCenterX();
        d7 = this.bottomWireNode.getFullBoundsReference().getMaxY() - d8 / 2.0;
        this.bottomCurrentIndicatorNode.setOffset(d6, d7);
        d6 = batteryNode.getFullBoundsReference().getMinX();
        d7 = this.topCurrentIndicatorNode.getFullBoundsReference().getMinY() - batteryConnectionButtonNode.getFullBoundsReference().getHeight() - 10.0;
        batteryConnectionButtonNode.setOffset(d6, d7);
        this.plateChargeControlNode.setOffset(cLModelViewTransform3D.modelToView(new Point3D.Double(singleCircuit.getCapacitor().getX() - 0.004, 0.001, 0.0)));
        singleCircuit.addCircuitChangeListener(new ICircuit.CircuitChangeListener(){

            public void circuitChanged() {
                DielectricCircuitNode.this.updateBatteryConnectivity();
            }
        });
        this.updateBatteryConnectivity();
    }

    public void setDielectricTransparent(boolean bl) {
        this.capacitorNode.getDielectricNode().setTransparent(bl);
    }

    private void updateBatteryConnectivity() {
        boolean bl = this.circuit.isBatteryConnected();
        this.topWireNode.setVisible(bl);
        this.bottomWireNode.setVisible(bl);
        this.topCurrentIndicatorNode.setVisible(bl);
        this.bottomCurrentIndicatorNode.setVisible(bl);
        this.plateChargeControlNode.setVisible(!this.circuit.isBatteryConnected());
    }
}

