/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view;

import edu.colorado.phet.capacitorlab.CLConstants;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.view.IGridSizeStrategy;
import edu.colorado.phet.capacitorlab.view.NegativeChargeNode;
import edu.colorado.phet.capacitorlab.view.PositiveChargeNode;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class DielectricExcessChargeNode
extends PhetPNode {
    private final Capacitor capacitor;
    private final CLModelViewTransform3D mvt;
    private final PNode parentNode;
    private final double maxExcessDielectricPlateCharge;
    private final IGridSizeStrategy gridSizeStrategy;

    public DielectricExcessChargeNode(Capacitor capacitor, CLModelViewTransform3D cLModelViewTransform3D, double d) {
        this.capacitor = capacitor;
        this.mvt = cLModelViewTransform3D;
        this.maxExcessDielectricPlateCharge = d;
        this.gridSizeStrategy = IGridSizeStrategy.GridSizeStrategyFactory.createStrategy();
        this.parentNode = new PComposite();
        this.addChild(this.parentNode);
        capacitor.addCapacitorChangeListener(new Capacitor.CapacitorChangeListener(){

            public void capacitorChanged() {
                if (DielectricExcessChargeNode.this.isVisible()) {
                    DielectricExcessChargeNode.this.update();
                }
            }
        });
        this.update();
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            super.setVisible(bl);
            if (bl) {
                this.update();
            }
        }
    }

    private void update() {
        this.parentNode.removeAllChildren();
        double d = this.capacitor.getExcessDielectricPlateCharge();
        double d2 = this.capacitor.getDielectricWidth();
        double d3 = this.capacitor.getDielectricDepth();
        double d4 = Math.max(0.0, d2 - this.capacitor.getDielectricOffset());
        if (d != 0.0 && d4 > 0.0) {
            double d5;
            int n;
            int n2 = this.getNumberOfCharges(d);
            double d6 = this.mvt.viewToModelDelta(new PositiveChargeNode().getFullBoundsReference().getWidth(), 0.0).getX();
            double d7 = d4;
            double d8 = d3 - 2.0 * d6;
            Dimension dimension = this.gridSizeStrategy.getGridSize(n2, d7, d8);
            int n3 = dimension.height;
            int n4 = dimension.width;
            double d9 = d7 / (double)n4;
            double d10 = d8 / (double)n3;
            double d11 = d9 / 2.0;
            double d12 = this.mvt.viewToModelDelta(0.0, new PositiveChargeNode().getFullBoundsReference().getHeight() + 1.0).getY();
            double d13 = d10 / 2.0;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    PNode pNode = DielectricExcessChargeNode.getBottomChargeNode(d);
                    this.parentNode.addChild(pNode);
                    double d14 = -d2 / 2.0 + d11 + (double)j * d9;
                    double d15 = this.capacitor.getDielectricHeight() - d12;
                    double d16 = -(d3 / 2.0) + d13 + (double)i * d10;
                    pNode.setOffset(this.mvt.modelToView(d14, d15, d16));
                }
            }
            double d17 = 0.0;
            double d18 = d12;
            for (n = 0; n < n4; ++n) {
                PNode pNode = DielectricExcessChargeNode.getTopChargeNode(d);
                this.parentNode.addChild(pNode);
                d17 = -d2 / 2.0 + d11 + (double)n * d9;
                d5 = -(d3 / 2.0);
                pNode.setOffset(this.mvt.modelToView(d17, d18, d5));
            }
            d17 += d11;
            for (n = 0; n < n3; ++n) {
                PNode pNode = DielectricExcessChargeNode.getTopChargeNode(d);
                this.parentNode.addChild(pNode);
                d5 = -d3 / 2.0 + d13 + (double)n * d10;
                Point2D point2D = this.mvt.modelToView(d17, d18, d5);
                pNode.setOffset(point2D);
            }
        }
    }

    private static PNode getTopChargeNode(double d) {
        return d > 0.0 ? new NegativeChargeNode() : new PositiveChargeNode();
    }

    private static PNode getBottomChargeNode(double d) {
        return d > 0.0 ? new PositiveChargeNode() : new NegativeChargeNode();
    }

    private int getNumberOfCharges(double d) {
        double d2 = Math.abs(d);
        int n = (int)((double)CLConstants.NUMBER_OF_PLATE_CHARGES.getMax() * d2 / this.maxExcessDielectricPlateCharge);
        if (d2 > 0.0 && n < CLConstants.NUMBER_OF_PLATE_CHARGES.getMin()) {
            n = CLConstants.NUMBER_OF_PLATE_CHARGES.getMin();
        }
        return n;
    }
}

