/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view;

import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.model.DielectricChargeView;
import edu.colorado.phet.capacitorlab.view.DielectricExcessChargeNode;
import edu.colorado.phet.capacitorlab.view.DielectricTotalChargeNode;
import edu.colorado.phet.capacitorlab.view.TransparentBoxNode;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DielectricNode
extends TransparentBoxNode {
    private final Capacitor capacitor;

    public DielectricNode(Capacitor capacitor, CLModelViewTransform3D cLModelViewTransform3D, final Property<DielectricChargeView> property, double d, double d2) {
        super(cLModelViewTransform3D, capacitor.getDielectricMaterial().getColor(), capacitor.getDielectricSize());
        this.capacitor = capacitor;
        final DielectricTotalChargeNode dielectricTotalChargeNode = new DielectricTotalChargeNode(capacitor, cLModelViewTransform3D, d2);
        this.addChild(dielectricTotalChargeNode);
        final DielectricExcessChargeNode dielectricExcessChargeNode = new DielectricExcessChargeNode(capacitor, cLModelViewTransform3D, d);
        this.addChild(dielectricExcessChargeNode);
        dielectricExcessChargeNode.moveToBack();
        property.addObserver(new SimpleObserver(){

            public void update() {
                dielectricTotalChargeNode.setVisible(property.get() == DielectricChargeView.TOTAL);
                dielectricExcessChargeNode.setVisible(property.get() == DielectricChargeView.EXCESS);
            }
        });
        capacitor.addDielectricMaterialObserver(new SimpleObserver(){

            public void update() {
                DielectricNode.this.setColor(DielectricNode.this.capacitor.getDielectricMaterial().getColor());
            }
        });
    }
}

