/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view;

import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.model.Polarity;
import edu.colorado.phet.capacitorlab.view.NegativeChargeNode;
import edu.colorado.phet.capacitorlab.view.PositiveChargeNode;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.nodes.PComposite;

public class DielectricTotalChargeNode
extends PhetPNode {
    private static final DoubleRange NEGATIVE_CHARGE_OFFSET = new DoubleRange(0.0, 22.0);
    private final Capacitor capacitor;
    private final CLModelViewTransform3D mvt;
    private final PNode parentNode;
    private final double maxDielectricEField;

    public DielectricTotalChargeNode(Capacitor capacitor, CLModelViewTransform3D cLModelViewTransform3D, double d) {
        this.capacitor = capacitor;
        this.mvt = cLModelViewTransform3D;
        this.maxDielectricEField = d;
        this.parentNode = new PComposite();
        this.addChild(this.parentNode);
        capacitor.addCapacitorChangeListener(new Capacitor.CapacitorChangeListener(){

            public void capacitorChanged() {
                if (DielectricTotalChargeNode.this.isVisible()) {
                    DielectricTotalChargeNode.this.update();
                }
            }
        });
        this.update();
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            super.setVisible(bl);
            if (bl) {
                this.update();
            }
        }
    }

    private void update() {
        this.parentNode.removeAllChildren();
        double d = this.capacitor.getDielectricEField();
        double d2 = this.getNegativeChargeOffset(d);
        double d3 = this.mvt.viewToModelDelta(45.0, 0.0).getX();
        double d4 = this.capacitor.getDielectricWidth();
        double d5 = this.capacitor.getDielectricHeight();
        double d6 = this.capacitor.getDielectricDepth();
        int n = (int)(d5 / d3);
        int n2 = (int)(d4 / d3);
        double d7 = (d4 - (double)n2 * d3) / 2.0;
        double d8 = (d5 - (double)n * d3) / 2.0;
        double d9 = d7;
        double d10 = d3 / 2.0;
        Polarity polarity = d >= 0.0 ? Polarity.NEGATIVE : Polarity.POSITIVE;
        double d11 = -(d4 / 2.0) + (d4 - this.capacitor.getDielectricOffset());
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                ChargePairNode chargePairNode = new ChargePairNode();
                this.parentNode.addChild(chargePairNode);
                double d12 = -(d4 / 2.0) + d10 + d7 + (double)j * d3;
                double d13 = d8 + d10 + (double)i * d3;
                double d14 = -d6 / 2.0;
                chargePairNode.setOffset(this.mvt.modelToView(d12, d13, d14));
                if (d12 <= d11) {
                    chargePairNode.setNegativeChargeOffset(d2, polarity);
                } else {
                    chargePairNode.setNegativeChargeOffset(NEGATIVE_CHARGE_OFFSET.getMin(), polarity);
                }
                chargePairNode = new ChargePairNode();
                this.parentNode.addChild(chargePairNode);
                d12 = d4 / 2.0;
                d13 = d8 + d10 + (double)i * d3;
                d14 = -d6 / 2.0 + d10 + d9 + (double)j * d3;
                chargePairNode.setOffset(this.mvt.modelToView(d12, d13, d14));
                if (this.capacitor.getDielectricOffset() == 0.0) {
                    chargePairNode.setNegativeChargeOffset(d2, polarity);
                    continue;
                }
                chargePairNode.setNegativeChargeOffset(NEGATIVE_CHARGE_OFFSET.getMin(), polarity);
            }
        }
    }

    private double getNegativeChargeOffset(double d) {
        double d2 = Math.abs(d);
        double d3 = Math.pow(d2 / this.maxDielectricEField, 0.25);
        return NEGATIVE_CHARGE_OFFSET.getMin() + d3 * NEGATIVE_CHARGE_OFFSET.getLength();
    }

    private static class ChargePairNode
    extends PComposite {
        private final PNode positiveNode = new PositiveChargeNode();
        private final PNode negativeNode;

        public ChargePairNode() {
            this.addChild(this.positiveNode);
            this.negativeNode = new NegativeChargeNode();
            this.addChild(this.negativeNode);
        }

        public void setNegativeChargeOffset(double d, Polarity polarity) {
            double d2 = polarity == Polarity.POSITIVE ? d : -d;
            this.negativeNode.setOffset(this.negativeNode.getXOffset(), d2);
        }
    }
}

