/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view;

import edu.colorado.phet.capacitorlab.CLConstants;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.model.Polarity;
import edu.colorado.phet.capacitorlab.view.IGridSizeStrategy;
import edu.colorado.phet.capacitorlab.view.NegativeChargeNode;
import edu.colorado.phet.capacitorlab.view.PositiveChargeNode;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Dimension;

public abstract class PlateChargeNode
extends PhetPNode {
    private final Capacitor capacitor;
    private final CLModelViewTransform3D mvt;
    private final Polarity polarity;
    private final PNode parentNode;
    private final IGridSizeStrategy gridSizeStrategy;
    private final double maxPlateCharge;
    private final float transparency;

    public PlateChargeNode(Capacitor capacitor, CLModelViewTransform3D cLModelViewTransform3D, Polarity polarity, double d, float f) {
        this.capacitor = capacitor;
        this.mvt = cLModelViewTransform3D;
        this.polarity = polarity;
        this.maxPlateCharge = d;
        this.gridSizeStrategy = IGridSizeStrategy.GridSizeStrategyFactory.createStrategy();
        this.transparency = f;
        capacitor.addCapacitorChangeListener(new Capacitor.CapacitorChangeListener(){

            public void capacitorChanged() {
                if (PlateChargeNode.this.isVisible()) {
                    PlateChargeNode.this.update();
                }
            }
        });
        this.parentNode = new PComposite();
        this.addChild(this.parentNode);
        this.update();
    }

    protected abstract double getPlateCharge();

    protected abstract double getContactXOrigin();

    protected abstract double getContactWidth();

    protected Capacitor getCapacitor() {
        return this.capacitor;
    }

    private boolean isPositivelyCharged() {
        return this.getPlateCharge() >= 0.0 && this.polarity == Polarity.POSITIVE || this.getPlateCharge() < 0.0 && this.polarity == Polarity.NEGATIVE;
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            super.setVisible(bl);
            if (bl) {
                this.update();
            }
        }
    }

    private void update() {
        double d = this.getPlateCharge();
        int n = PlateChargeNode.getNumberOfCharges(d, this.maxPlateCharge);
        this.parentNode.removeAllChildren();
        if (n > 0) {
            double d2 = this.mvt.viewToModelDelta(new PositiveChargeNode().getFullBoundsReference().getWidth(), 0.0).getX();
            double d3 = this.getContactWidth();
            double d4 = this.getCapacitor().getPlateDepth() - 2.0 * d2;
            Dimension dimension = this.gridSizeStrategy.getGridSize(n, d3, d4);
            int n2 = dimension.height;
            int n3 = dimension.width;
            double d5 = d3 / (double)n3;
            double d6 = d4 / (double)n2;
            double d7 = d5 / 2.0;
            double d8 = d6 / 2.0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    PNode pNode = this.isPositivelyCharged() ? new PositiveChargeNode() : new NegativeChargeNode();
                    pNode.setTransparency(this.transparency);
                    this.parentNode.addChild(pNode);
                    double d9 = this.getContactXOrigin() + d7 + (double)j * d5;
                    double d10 = 0.0;
                    double d11 = -(d4 / 2.0) + d2 / 2.0 + d8 + (double)i * d6;
                    if (n == 1) {
                        d11 -= d6 / 6.0;
                    }
                    pNode.setOffset(this.mvt.modelToView(d9, d10, d11));
                }
            }
        }
    }

    public static int getNumberOfCharges(double d, double d2) {
        double d3 = Math.abs(d);
        int n = (int)((double)CLConstants.NUMBER_OF_PLATE_CHARGES.getMax() * d3 / d2);
        if (d3 > 0.0 && n < CLConstants.NUMBER_OF_PLATE_CHARGES.getMin()) {
            n = CLConstants.NUMBER_OF_PLATE_CHARGES.getMin();
        }
        return n;
    }

    public static class AirPlateChargeNode
    extends PlateChargeNode {
        public AirPlateChargeNode(Capacitor capacitor, CLModelViewTransform3D cLModelViewTransform3D, Polarity polarity, double d) {
            super(capacitor, cLModelViewTransform3D, polarity, d, 1.0f);
        }

        protected double getPlateCharge() {
            return this.getCapacitor().getAirPlateCharge();
        }

        protected double getContactXOrigin() {
            return -this.getCapacitor().getPlateWidth() / 2.0;
        }

        protected double getContactWidth() {
            return Math.min(this.getCapacitor().getDielectricOffset(), this.getCapacitor().getPlateWidth());
        }
    }

    public static class DielectricPlateChargeNode
    extends PlateChargeNode {
        public DielectricPlateChargeNode(Capacitor capacitor, CLModelViewTransform3D cLModelViewTransform3D, Polarity polarity, double d, float f) {
            super(capacitor, cLModelViewTransform3D, polarity, d, f);
        }

        protected double getPlateCharge() {
            return this.getCapacitor().getDielectricPlateCharge();
        }

        protected double getContactXOrigin() {
            return -(this.getCapacitor().getPlateWidth() / 2.0) + this.getCapacitor().getDielectricOffset();
        }

        protected double getContactWidth() {
            return Math.max(0.0, this.getCapacitor().getPlateWidth() - this.getCapacitor().getDielectricOffset());
        }
    }
}

