/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view.meters;

import edu.colorado.phet.capacitorlab.CLPaints;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.meter.Voltmeter;
import edu.colorado.phet.capacitorlab.view.meters.ProbeWireNode;
import edu.colorado.phet.capacitorlab.view.meters.VoltmeterBodyNode;
import edu.colorado.phet.capacitorlab.view.meters.VoltmeterProbeNode;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import java.awt.geom.Point2D;

public class VoltmeterNode
extends PhetPNode {
    private static final Point2D BODY_CONTROL_POINT_OFFSET = new Point2D.Double(-25.0, 0.0);
    private static final Point2D PROBE_CONTROL_POINT_OFFSET = new Point2D.Double(-80.0, 100.0);

    public VoltmeterNode(final Voltmeter voltmeter, CLModelViewTransform3D cLModelViewTransform3D) {
        VoltmeterBodyNode voltmeterBodyNode = new VoltmeterBodyNode(voltmeter, cLModelViewTransform3D);
        VoltmeterProbeNode.PositiveVoltmeterProbeNode positiveVoltmeterProbeNode = new VoltmeterProbeNode.PositiveVoltmeterProbeNode(voltmeter, cLModelViewTransform3D);
        VoltmeterProbeNode.NegativeVoltmeterProbeNode negativeVoltmeterProbeNode = new VoltmeterProbeNode.NegativeVoltmeterProbeNode(voltmeter, cLModelViewTransform3D);
        ProbeWireNode probeWireNode = new ProbeWireNode(voltmeterBodyNode, positiveVoltmeterProbeNode, BODY_CONTROL_POINT_OFFSET, PROBE_CONTROL_POINT_OFFSET, voltmeterBodyNode.getPositiveConnectionOffset(), positiveVoltmeterProbeNode.getConnectionOffset(), CLPaints.VOLTMETER_POSITIVE_WIRE);
        ProbeWireNode probeWireNode2 = new ProbeWireNode(voltmeterBodyNode, negativeVoltmeterProbeNode, BODY_CONTROL_POINT_OFFSET, PROBE_CONTROL_POINT_OFFSET, voltmeterBodyNode.getNegativeConnectionOffset(), negativeVoltmeterProbeNode.getConnectionOffset(), CLPaints.VOLTMETER_NEGATIVE_WIRE);
        this.addChild(voltmeterBodyNode);
        this.addChild(positiveVoltmeterProbeNode);
        this.addChild(probeWireNode);
        this.addChild(negativeVoltmeterProbeNode);
        this.addChild(probeWireNode2);
        voltmeter.visibleProperty.addObserver(new SimpleObserver(){

            public void update() {
                VoltmeterNode.this.setVisible(voltmeter.isVisible());
            }
        });
    }
}

