/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.resources;

import edu.colorado.phet.common.phetcommon.resources.DefaultResourceLoader;
import edu.colorado.phet.common.phetcommon.resources.DummyConstantStringTester;
import edu.colorado.phet.common.phetcommon.resources.IResourceLoader;
import edu.colorado.phet.common.phetcommon.resources.PhetProperties;
import edu.colorado.phet.common.phetcommon.resources.PhetVersion;
import edu.colorado.phet.common.phetcommon.util.logging.LoggingUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhetResources {
    private static final Logger LOGGER = LoggingUtils.getLogger(PhetResources.class.getCanonicalName());
    private final String projectName;
    private final Locale locale;
    private final PhetProperties localizedProperties;
    private final PhetProperties projectProperties;
    private final IResourceLoader resourceLoader;
    private final String rootDirectoryName;
    private volatile PhetVersion version;

    public PhetResources(String string) {
        this(string, PhetResources.readLocale(), new DefaultResourceLoader());
    }

    public PhetResources(String string, Locale locale, IResourceLoader iResourceLoader) {
        this.projectName = string;
        this.rootDirectoryName = string;
        this.locale = locale;
        this.resourceLoader = iResourceLoader;
        String string2 = string + ".properties";
        this.projectProperties = iResourceLoader.exists(this.rootDirectoryName + '/' + string2) ? this.getProperties(string2) : new PhetProperties();
        String string3 = "localization/" + string + "-strings";
        this.localizedProperties = this.getProperties(string3);
    }

    public static Locale readLocale() {
        Locale locale = Locale.getDefault();
        LOGGER.fine("readLocale: default locale=" + locale.toString());
        String string = System.getProperty("javaws.user.language");
        String string2 = System.getProperty("javaws.user.country");
        if (string != null) {
            if (string2 != null) {
                LOGGER.fine("readLocale: overriding locale via javaws.user.language=" + string + " " + "javaws.user.country" + "=" + string2);
                locale = new Locale(string, string2);
            } else {
                LOGGER.fine("readLocale: overriding locale via javaws.user.language=" + string);
                locale = new Locale(string);
            }
        } else if (string2 != null) {
            LOGGER.fine("readLocale: ignoring locale properties, they are in an illegal state, country specified without language");
        }
        LOGGER.fine("readLocale: returning locale=" + locale.toString());
        return locale;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public PhetProperties getLocalizedProperties() {
        return this.localizedProperties;
    }

    public BufferedImage getImage(String string) {
        return this.resourceLoader.getImage(this.rootDirectoryName + '/' + "images" + '/' + string);
    }

    public InputStream getResourceAsStream(String string) throws IOException {
        return this.resourceLoader.getResourceAsStream(this.rootDirectoryName + '/' + string);
    }

    public PhetProperties getProperties(String string) {
        return this.resourceLoader.getProperties(this.rootDirectoryName + '/' + string, this.locale);
    }

    public String getProjectProperty(String string) {
        return this.projectProperties.getProperty(string);
    }

    public String getLocalizedString(String string) {
        return DummyConstantStringTester.getString(this.localizedProperties.getString(string));
    }

    public String getName(String string) {
        return this.localizedProperties.getProperty(string + "." + "name");
    }

    public PhetVersion getVersion() {
        if (this.version == null) {
            this.version = PhetResources.getVersion(this.projectProperties);
        }
        return this.version;
    }

    public static PhetVersion getVersion(Properties properties) {
        String string = properties.getProperty("version.major");
        String string2 = properties.getProperty("version.minor");
        String string3 = properties.getProperty("version.dev");
        String string4 = properties.getProperty("version.revision");
        String string5 = properties.getProperty("version.timestamp");
        return new PhetVersion(string, string2, string3, string4, string5);
    }

    public String getDistributionTag() {
        return this.getProjectProperty("distribution.tag");
    }

    static {
        LOGGER.setLevel(Level.WARNING);
    }
}

