/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ButtonNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Font;

public class TextButtonNode
extends ButtonNode {
    private String text;
    private Font font;
    private Color enabledTextColor = Color.black;
    private Color disabledTextColor = Color.gray;

    public TextButtonNode(String string) {
        this(string, new PhetFont(0, 14));
    }

    public TextButtonNode(String string, Font font) {
        this(string, font, Color.gray);
    }

    public TextButtonNode(String string, Font font, Color color) {
        super(string, new ContentNode(string, font, Color.black), new ContentNode(string, font, Color.gray));
        this.text = string;
        this.font = font;
        this.setBackground(color);
        this.updateContentNodes();
    }

    public void setText(String string) {
        if (!string.equals(this.text)) {
            this.text = string;
            this.updateContentNodes();
        }
    }

    public void setFont(Font font) {
        this.font = font;
        this.updateContentNodes();
    }

    private void updateContentNodes() {
        this.setContentNode(new ContentNode(this.text, this.font, this.enabledTextColor));
        this.setDisabledContentNode(new ContentNode(this.text, this.font, this.disabledTextColor));
    }

    private static class ContentNode
    extends PText {
        public ContentNode(String string, Font font, Color color) {
            super(string);
            this.setFont(font);
            this.setTextPaint(color);
        }
    }
}

