/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.PolarCartesianConverter;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class Vector2DNode
extends PhetPNode {
    private static final Stroke DEFAULT_ARROW_STROKE = new BasicStroke(1.0f);
    private static final Paint DEFAULT_ARROW_STROKE_PAINT = Color.BLACK;
    private static final Paint DEFAULT_ARROW_FILL_PAINT = Color.WHITE;
    private static final Font DEFAULT_VALUE_FONT = new PhetFont();
    private static final Paint DEFAULT_VALUE_PAINT = Color.BLACK;
    private static final DecimalFormat DEFAULT_VALUE_FORMAT = new DecimalFormat("0.##E0");
    private static final Point2D TAIL_POSITION = new Point2D.Double(0.0, 0.0);
    private double _x;
    private double _y;
    private final double _referenceMagnitude;
    private final double _referenceLength;
    private PPath _arrowNode;
    private PText _valueNode;
    private double _headWidth;
    private double _headHeight;
    private double _tailWidth;
    private double _fractionalHeadHeight;
    private double _valueSpacing;
    private DecimalFormat _valueFormat;
    private String _units;
    private boolean _updateEnabled;
    private Point2D _somePoint;

    public Vector2DNode(double d, double d2, double d3, double d4) {
        assert (d3 > 0.0);
        assert (d4 > 0.0);
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._x = d;
        this._y = d2;
        this._referenceMagnitude = d3;
        this._referenceLength = d4;
        this._arrowNode = new PPath();
        this._arrowNode.setPaint(DEFAULT_ARROW_FILL_PAINT);
        this._arrowNode.setStroke(DEFAULT_ARROW_STROKE);
        this._arrowNode.setStrokePaint(DEFAULT_ARROW_STROKE_PAINT);
        this.addChild(this._arrowNode);
        this._valueNode = new PText();
        this._valueNode.setTextPaint(DEFAULT_VALUE_PAINT);
        this._valueNode.setFont(DEFAULT_VALUE_FONT);
        this.addChild(this._valueNode);
        this._valueNode.setVisible(false);
        this._headWidth = 20.0;
        this._headHeight = 20.0;
        this._tailWidth = 5.0;
        this._fractionalHeadHeight = 0.5;
        this._valueSpacing = 0.0;
        this._valueFormat = DEFAULT_VALUE_FORMAT;
        this._units = "";
        this._updateEnabled = true;
        this._somePoint = new Point2D.Double();
        this.update();
    }

    public ImmutableVector2D getVector() {
        return new ImmutableVector2D(this._x, this._y);
    }

    public void setXY(double d, double d2) {
        if (d != this._x || d2 != this._y) {
            this._x = d;
            this._y = d2;
            this.update();
        }
    }

    public void setHeadSize(double d, double d2) {
        if (d != this._headWidth || d2 != this._headHeight) {
            this._headWidth = d;
            this._headHeight = d2;
            this.update();
        }
    }

    public void setHeadSize(Dimension dimension) {
        this.setHeadSize(dimension.width, dimension.height);
    }

    public void setTailWidth(double d) {
        if (d != this._tailWidth) {
            this._tailWidth = d;
            this.update();
        }
    }

    public void setArrowFillPaint(Paint paint) {
        this._arrowNode.setPaint(paint);
    }

    private void update() {
        if (this._updateEnabled) {
            Object object;
            double d = PolarCartesianConverter.getRadius(this._x, this._y);
            double d2 = this._x * (this._referenceLength / this._referenceMagnitude);
            double d3 = this._y * (this._referenceLength / this._referenceMagnitude);
            this._somePoint.setLocation(d2, d3);
            if (d == 0.0) {
                this._arrowNode.setPathTo(new Rectangle2D.Double());
            } else {
                object = new Arrow(TAIL_POSITION, this._somePoint, this._headHeight, this._headWidth, this._tailWidth, this._fractionalHeadHeight, true);
                this._arrowNode.setPathTo(((Arrow)object).getShape());
            }
            if (this._valueNode.getVisible()) {
                object = this._valueFormat.format(d);
                if (this._units != null && this._units.length() > 0) {
                    object = (String)object + " " + this._units;
                }
                this._valueNode.setText((String)object);
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = this._valueNode.getFullBoundsReference().getWidth();
                double d7 = this._valueNode.getFullBoundsReference().getHeight();
                double d8 = 0.0;
                double d9 = PolarCartesianConverter.getAngle(this._x, this._y);
                if (d9 < 0.0) {
                    d9 += Math.PI * 2;
                }
                if (d9 >= 0.0 && d9 < 0.7853981633974483) {
                    d8 = d9 / 0.7853981633974483;
                    d4 = d2 + this._valueSpacing;
                    d5 = d3 - (1.0 - d8) * d7 / 2.0 + d8 * this._valueSpacing;
                } else if (d9 >= 0.7853981633974483 && d9 < 1.5707963267948966) {
                    d8 = (1.5707963267948966 - d9) / 0.7853981633974483;
                    d4 = d2 - (1.0 - d8) * d6 / 2.0 + d8 * this._valueSpacing;
                    d5 = d3 + this._valueSpacing;
                } else if (d9 >= 1.5707963267948966 && d9 < 2.356194490192345) {
                    d8 = (2.356194490192345 - d9) / 0.7853981633974483;
                    d4 = d2 - d6 / 2.0 - (1.0 - d8) * d6 / 2.0 - (1.0 - d8) * this._valueSpacing;
                    d5 = d3 + this._valueSpacing;
                } else if (d9 >= 2.356194490192345 && d9 < Math.PI) {
                    d8 = (Math.PI - d9) / 0.7853981633974483;
                    d4 = d2 - d6 - this._valueSpacing;
                    d5 = d3 - (1.0 - d8) * d7 / 2.0 + d8 * this._valueSpacing;
                } else if (d9 >= Math.PI && d9 < 3.9269908169872414) {
                    d8 = (3.9269908169872414 - d9) / 0.7853981633974483;
                    d4 = d2 - d6 - this._valueSpacing;
                    d5 = d3 - d7 / 2.0 - (1.0 - d8) * d7 / 2.0 - (1.0 - d8) * this._valueSpacing;
                } else if (d9 >= 3.9269908169872414 && d9 < 4.71238898038469) {
                    d8 = (4.71238898038469 - d9) / 0.7853981633974483;
                    d4 = d2 - d6 + (1.0 - d8) * d6 / 2.0 - d8 * this._valueSpacing;
                    d5 = d3 - d7 - this._valueSpacing;
                } else if (d9 >= 4.71238898038469 && d9 < 5.497787143782138) {
                    d8 = (5.497787143782138 - d9) / 0.7853981633974483;
                    d4 = d2 - d6 / 2.0 + (1.0 - d8) * d6 / 2.0 + (1.0 - d8) * this._valueSpacing;
                    d5 = d3 - d7 - this._valueSpacing;
                } else {
                    d8 = (Math.PI * 2 - d9) / 0.7853981633974483;
                    d4 = d2 + this._valueSpacing;
                    d5 = d3 - d7 + (1.0 - d8) * d7 / 2.0 - d8 * this._valueSpacing;
                }
                this._valueNode.setOffset(d4, d5);
            }
        }
    }
}

