/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenuBar;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ConstantParser;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.swing.RadioButtonInterface;
import org.colos.ejs.library.control.value.BooleanValue;

public abstract class ControlContainer
extends ControlSwingElement {
    private static final BooleanValue falseValue = new BooleanValue(false);
    protected Vector radioButtons = new Vector();
    protected Vector children = new Vector();

    public Container getContainer() {
        return (Container)this.getVisual();
    }

    public boolean acceptsChild(ControlElement controlElement) {
        if (controlElement.getVisual() instanceof JMenuBar) {
            return false;
        }
        return controlElement instanceof ControlSwingElement;
    }

    public void add(ControlElement controlElement) {
        this.children.add(controlElement);
        Container container = this.getContainer();
        LayoutManager layoutManager = container.getLayout();
        String string = controlElement.getProperty("_ejs_indexInParent_");
        int n = -1;
        if (string != null) {
            n = Integer.parseInt(string);
        }
        controlElement.setProperty("_ejs_indexInParent_", null);
        if (layoutManager instanceof BorderLayout) {
            String string2 = controlElement.getProperty("position");
            if (string2 != null) {
                container.add(controlElement.getComponent(), ConstantParser.constraintsConstant(string2).getString(), n);
            } else {
                container.add(controlElement.getComponent(), "Center", n);
            }
        } else {
            container.add(controlElement.getComponent(), n);
        }
        this.adjustSize();
        if (controlElement instanceof RadioButtonInterface) {
            this.radioButtons.add(controlElement);
            ((RadioButtonInterface)((Object)controlElement)).setControlParent(this);
        }
        this.propagateProperty(controlElement, "font", this.getPropagatedProperty("font"));
        this.propagateProperty(controlElement, "foreground", this.getPropagatedProperty("foreground"));
        this.propagateProperty(controlElement, "background", this.getPropagatedProperty("background"));
    }

    protected void adjustChildren() {
        Container container = this.getContainer();
        if (container.getLayout() instanceof BorderLayout) {
            container.removeAll();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("center");
            arrayList.add("north");
            arrayList.add("south");
            arrayList.add("east");
            arrayList.add("west");
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                ControlElement controlElement = (ControlElement)enumeration.nextElement();
                String string = controlElement.getProperty("position");
                if (string == null) {
                    string = (String)arrayList.get(0);
                }
                if (string == null) {
                    string = "center";
                } else {
                    arrayList.remove(string);
                }
                container.add(controlElement.getComponent(), ConstantParser.constraintsConstant(string).getString(), -1);
            }
        }
    }

    public void adjustSize() {
        this.getContainer().validate();
        this.getContainer().repaint();
        ControlContainer.resizeContainer(this.getContainer());
        ControlContainer.resizeContainer(this.getComponent().getParent());
    }

    private static void resizeContainer(Container container) {
        if (container == null) {
            return;
        }
        Rectangle rectangle = container.getBounds();
        container.setBounds(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
        container.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        container.validate();
        container.repaint();
    }

    public Vector getChildren() {
        return this.children;
    }

    public void remove(ControlElement controlElement) {
        this.children.remove(controlElement);
        Container container = this.getContainer();
        container.remove(controlElement.getComponent());
        if (controlElement instanceof RadioButtonInterface) {
            this.radioButtons.remove(controlElement);
            ((RadioButtonInterface)((Object)controlElement)).setControlParent(null);
        }
        this.adjustSize();
    }

    public void informRadioGroup(RadioButtonInterface radioButtonInterface, boolean bl) {
        if (!bl) {
            return;
        }
        Enumeration enumeration = this.radioButtons.elements();
        while (enumeration.hasMoreElements()) {
            ControlSwingElement controlSwingElement = (ControlSwingElement)enumeration.nextElement();
            if (controlSwingElement == radioButtonInterface) continue;
            boolean bl2 = controlSwingElement.isActive();
            controlSwingElement.setActive(false);
            controlSwingElement.setValue(radioButtonInterface.getVariableIndex(), falseValue);
            ((RadioButtonInterface)((Object)controlSwingElement)).reportChanges();
            controlSwingElement.setActive(bl2);
        }
    }

    protected void propagateProperty(ControlElement controlElement, String string, String string2) {
        if (controlElement.getProperty(string) == null) {
            controlElement.setProperty(string, string2, false);
        }
    }

    protected void propagateProperty(String string, String string2) {
        int n = 0;
        while (n < this.children.size()) {
            this.propagateProperty((ControlElement)this.children.elementAt(n), string, string2);
            ++n;
        }
    }

    protected String getPropagatedProperty(String string) {
        String string2 = this.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        ControlElement controlElement = this.myGroup.getElement(this.getProperty("parent"));
        if (controlElement != null && controlElement instanceof ControlContainer) {
            return ((ControlContainer)controlElement).getPropagatedProperty(string);
        }
        return null;
    }

    public ControlElement setProperty(String string, String string2, boolean bl) {
        ControlElement controlElement = super.setProperty(string, string2, bl);
        if (string.equals("font") || string.equals("foreground") || string.equals("background")) {
            this.propagateProperty(string, string2);
        }
        return controlElement;
    }
}

