/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.OSPRuntime;

public class ControlPanel
extends ControlContainer {
    public static final int PANEL_ADDED = 7;
    public static final int EMPTY_BORDER = 0;
    public static final int LOWERED_BEVEL_BORDER = 1;
    public static final int RAISED_BEVEL_BORDER = 2;
    public static final int LOWERED_ETCHED_BORDER = 3;
    public static final int RAISED_ETCHED_BORDER = 4;
    public static final int LINE_BORDER = 5;
    public static final int ROUNDED_LINE_BORDER = 6;
    public static final int MATTE_BORDER = 7;
    public static final int TITLED_BORDER = 8;
    public static final int ROUNDED_TITLED_BORDER = 9;
    protected JPanel panel;
    private LayoutManager myLayout = null;
    private Rectangle myBorder = new Rectangle(0, 0, 0, 0);
    private int borderType = 0;
    private Color borderColor = Color.BLACK;
    private String borderTitle = "Title";
    private int borderPosition = 0;
    private int borderJustification = 0;
    private static ArrayList infoList = null;

    protected Component createVisual() {
        this.panel = new JPanel();
        this.panel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && ControlPanel.this.getSimulation() != null) {
                    if (keyEvent.getKeyCode() == 77) {
                        ControlPanel.this.getPopupMenu(0, 0);
                    } else if (keyEvent.getKeyCode() == 80) {
                        ControlPanel.this.printScreen();
                    }
                }
            }
        });
        this.panel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (ControlPanel.this.getSimulation() != null && OSPRuntime.isPopupTrigger(mouseEvent)) {
                    ControlPanel.this.getPopupMenu(mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        return this.panel;
    }

    private void setBorder() {
        AbstractBorder abstractBorder;
        switch (this.borderType) {
            default: {
                abstractBorder = new EmptyBorder(this.myBorder.x, this.myBorder.y, this.myBorder.width, this.myBorder.height);
                break;
            }
            case 1: {
                abstractBorder = new BevelBorder(1);
                break;
            }
            case 2: {
                abstractBorder = new BevelBorder(0);
                break;
            }
            case 3: {
                abstractBorder = new EtchedBorder(1);
                break;
            }
            case 4: {
                abstractBorder = new EtchedBorder(0);
                break;
            }
            case 5: 
            case 6: {
                int n = Math.max(Math.max(Math.max(Math.max(this.myBorder.x, this.myBorder.y), this.myBorder.width), this.myBorder.height), 1);
                abstractBorder = new LineBorder(this.borderColor, n, this.borderType == 6);
                break;
            }
            case 7: {
                abstractBorder = new MatteBorder(this.myBorder.x, this.myBorder.y, this.myBorder.width, this.myBorder.height, this.borderColor);
                break;
            }
            case 8: 
            case 9: {
                int n = Math.max(Math.max(Math.max(Math.max(this.myBorder.x, this.myBorder.y), this.myBorder.width), this.myBorder.height), 1);
                abstractBorder = new TitledBorder(new LineBorder(this.borderColor, n, this.borderType == 9), this.borderTitle, this.borderJustification, this.borderPosition, this.panel.getFont(), this.panel.getForeground());
            }
        }
        this.panel.setBorder(abstractBorder);
    }

    public ControlElement setProperty(String string, String string2, boolean bl) {
        ControlElement controlElement = super.setProperty(string, string2, bl);
        if (string.equals("font") || string.equals("foreground")) {
            this.setBorder();
        }
        return controlElement;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("layout");
            infoList.add("border");
            infoList.add("borderType");
            infoList.add("borderColor");
            infoList.add("borderTitle");
            infoList.add("borderPosition");
            infoList.add("borderJustification");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("layout")) {
            return "Layout|Object NO_RESET";
        }
        if (string.equals("border")) {
            return "Margins|Object";
        }
        if (string.equals("borderType")) {
            return "BorderType|int";
        }
        if (string.equals("borderColor")) {
            return "Color|Object";
        }
        if (string.equals("borderTitle")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("borderPosition")) {
            return "BorderPosition|int";
        }
        if (string.equals("borderJustification")) {
            return "Alignment|int";
        }
        return super.getPropertyInfo(string);
    }

    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("BorderType") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("empty")) {
                return new IntegerValue(0);
            }
            if (string2.equals("lowered_bevel")) {
                return new IntegerValue(1);
            }
            if (string2.equals("raised_bevel")) {
                return new IntegerValue(2);
            }
            if (string2.equals("lowered_etched")) {
                return new IntegerValue(3);
            }
            if (string2.equals("raised_etched")) {
                return new IntegerValue(4);
            }
            if (string2.equals("line")) {
                return new IntegerValue(5);
            }
            if (string2.equals("rounded_line")) {
                return new IntegerValue(6);
            }
            if (string2.equals("matte")) {
                return new IntegerValue(7);
            }
            if (string2.equals("titled")) {
                return new IntegerValue(8);
            }
            if (string2.equals("rounded_titled")) {
                return new IntegerValue(9);
            }
        } else if (string.indexOf("BorderPosition") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("top")) {
                return new IntegerValue(2);
            }
            if (string2.equals("bottom")) {
                return new IntegerValue(5);
            }
            if (string2.equals("above_top")) {
                return new IntegerValue(1);
            }
            if (string2.equals("above_bottom")) {
                return new IntegerValue(4);
            }
            if (string2.equals("below_top")) {
                return new IntegerValue(3);
            }
            if (string2.equals("below_bottom")) {
                return new IntegerValue(6);
            }
        } else if (string.indexOf("Alignment") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("left")) {
                return new IntegerValue(1);
            }
            if (string2.equals("center")) {
                return new IntegerValue(2);
            }
            if (string2.equals("right")) {
                return new IntegerValue(3);
            }
        }
        return super.parseConstant(string, string2);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                LayoutManager layoutManager;
                if (!(value.getObject() instanceof LayoutManager) || (layoutManager = (LayoutManager)value.getObject()) == this.myLayout) break;
                this.myLayout = layoutManager;
                this.getContainer().setLayout(this.myLayout);
                this.adjustChildren();
                this.panel.validate();
                break;
            }
            case 1: {
                Rectangle rectangle;
                if (!(value.getObject() instanceof Rectangle) || (rectangle = (Rectangle)value.getObject()) == this.myBorder) break;
                this.myBorder = rectangle;
                this.setBorder();
                break;
            }
            case 2: {
                if (value.getInteger() == this.borderType) break;
                this.borderType = value.getInteger();
                this.setBorder();
                break;
            }
            case 3: {
                Color color;
                if (!(value.getObject() instanceof Color) || (color = (Color)value.getObject()) == this.borderColor) break;
                this.borderColor = color;
                this.setBorder();
                break;
            }
            case 4: {
                if (this.borderTitle.equals(value.getString())) break;
                this.borderTitle = value.getString();
                this.setBorder();
                break;
            }
            case 5: {
                if (value.getInteger() == this.borderPosition) break;
                this.borderPosition = value.getInteger();
                this.setBorder();
                break;
            }
            case 6: {
                if (value.getInteger() == this.borderJustification) break;
                this.borderJustification = value.getInteger();
                this.setBorder();
                break;
            }
            default: {
                super.setValue(n - 7, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.myLayout = new BorderLayout();
                this.getContainer().setLayout(this.myLayout);
                this.adjustChildren();
                this.panel.validate();
                break;
            }
            case 1: {
                this.myBorder = new Rectangle(0, 0, 0, 0);
                this.setBorder();
                break;
            }
            case 2: {
                this.borderType = 0;
                this.setBorder();
                break;
            }
            case 3: {
                this.borderColor = Color.BLACK;
                this.setBorder();
                break;
            }
            case 4: {
                this.borderTitle = "Title";
                this.setBorder();
                break;
            }
            case 5: {
                this.borderPosition = 1;
                this.setBorder();
                break;
            }
            case 6: {
                this.borderJustification = 1;
                this.setBorder();
                break;
            }
            default: {
                super.setDefaultValue(n - 7);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "BORDER";
            }
            case 1: {
                return "0,0,0,0";
            }
            case 2: {
                return "EMPTY";
            }
            case 3: {
                return "BLACK";
            }
            case 4: {
                return "Title";
            }
            case 5: {
                return "ABOVE_TOP";
            }
            case 6: {
                return "LEFT";
            }
        }
        return super.getDefaultValueString(n - 7);
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return null;
            }
        }
        return super.getValue(n - 7);
    }
}

