/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.utils.TranslatorUtil;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.TranslatorTool;

public class TranslatorUtilClass
extends TranslatorUtil {
    static ResourceBundle ejsRes = ResourceBundle.getBundle("org.opensourcephysics.resources.ejs.ejs_res", Locale.getDefault());
    private Simulation simulation;
    private JMenu langMenu = null;

    public TranslatorUtilClass(Simulation simulation) {
        this.simulation = simulation;
    }

    public void setLocale(Locale locale) {
        TranslatorTool.getTool().setLocale(locale);
    }

    public void addToMenu(JMenu jMenu) {
        if (this.simulation.getModel()._getApplet() != null) {
            return;
        }
        this.langMenu = new JMenu(ToolsRes.getString("TranslatorTool.Label.Description"));
        jMenu.add(this.langMenu);
        try {
            System.getProperty("user.home");
            jMenu.add(new AbstractAction(ToolsRes.getString("TranslatorTool.Title")){

                public void actionPerformed(ActionEvent actionEvent) {
                    TranslatorUtilClass.this.translate();
                }
            });
        }
        catch (Exception exception) {}
    }

    public String translateString(String string, String string2) {
        boolean bl = false;
        if (string2.startsWith("\"") && string2.endsWith("\"")) {
            bl = true;
            string2 = string2.substring(1, string2.length() - 1);
        }
        String string3 = TranslatorTool.getTool().getProperty(this.simulation.getModel().getClass(), string, string2);
        if (bl) {
            string3 = "\"" + string3 + "\"";
        }
        return string3;
    }

    public String translateString(String string) {
        boolean bl = false;
        if (string.startsWith("\"") && string.endsWith("\"")) {
            bl = true;
            string = string.substring(1, string.length() - 1);
        }
        String string2 = TranslatorTool.getTool().getProperty(this.simulation.getModel().getClass(), string);
        if (bl) {
            string2 = "\"" + string2 + "\"";
        }
        return string2;
    }

    public void refreshMenu() {
        if (this.langMenu == null) {
            return;
        }
        this.langMenu.removeAll();
        Locale[] localeArray = TranslatorTool.getTool().getTranslatedLocales(this.simulation.getModel().getClass());
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TranslatorUtilClass.this.simulation.setLocale(actionEvent.getActionCommand());
            }
        };
        int n = 0;
        while (n < localeArray.length) {
            JMenuItem jMenuItem = new JMenuItem(localeArray[n].getDisplayLanguage(localeArray[n]));
            jMenuItem.setActionCommand(localeArray[n].getLanguage());
            jMenuItem.addActionListener(actionListener);
            this.langMenu.add(jMenuItem);
            ++n;
        }
    }

    private void translate() {
        TranslatorTool translatorTool = TranslatorTool.getTool();
        translatorTool.showProperties(this.simulation.getModel().getClass());
        translatorTool.setKeepHidden(false);
        translatorTool.setVisible(true);
    }
}

