/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.util.Collection;
import java.util.HashSet;
import javax.swing.table.AbstractTableModel;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.tools.ArrayInspector;

public class XMLTableModel
extends AbstractTableModel {
    XMLControl control;
    boolean editable = true;
    Collection<String> uneditablePropNames = new HashSet<String>();

    public XMLTableModel(XMLControl xMLControl) {
        this.control = xMLControl;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int n) {
        return n == 0 ? ControlsRes.XML_NAME : ControlsRes.XML_VALUE;
    }

    public int getRowCount() {
        return this.control.getPropertyContent().size();
    }

    public Object getValueAt(int n, int n2) {
        try {
            XMLProperty xMLProperty = (XMLProperty)this.control.getPropertyContent().get(n);
            Object object = xMLProperty.getPropertyContent().get(0);
            if (object.toString().indexOf("![CDATA[") > -1) {
                object = this.control.getString(xMLProperty.getPropertyName());
            }
            return n2 == 0 ? xMLProperty.getPropertyName() : object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0) {
            return false;
        }
        String string = (String)this.getValueAt(n, 0);
        if (this.uneditablePropNames.contains(string)) {
            return false;
        }
        Object object = this.getValueAt(n, n2);
        if (object instanceof XMLControl) {
            return true;
        }
        if (object instanceof XMLProperty) {
            XMLProperty xMLProperty = (XMLProperty)object;
            XMLProperty xMLProperty2 = xMLProperty.getParentProperty();
            if (xMLProperty2.getPropertyType().equals("array")) {
                return ArrayInspector.canInspect(xMLProperty2);
            }
            return xMLProperty2.getPropertyType().equals("collection");
        }
        return true;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object == null) {
            return;
        }
        boolean bl = false;
        if (object instanceof String) {
            XMLControl xMLControl;
            String string = (String)object;
            XMLProperty xMLProperty = (XMLProperty)this.control.getPropertyContent().get(n);
            bl = !string.equals(this.control.getString(xMLProperty.getPropertyName()));
            String string2 = xMLProperty.getPropertyType();
            if (string2.equals("string")) {
                this.control.setValue(xMLProperty.getPropertyName(), string);
            } else if (string2.equals("int")) {
                try {
                    int n3 = Integer.parseInt(string);
                    this.control.setValue(xMLProperty.getPropertyName(), n3);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string2.equals("double")) {
                try {
                    double d = Double.parseDouble(string);
                    this.control.setValue(xMLProperty.getPropertyName(), d);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string2.equals("boolean")) {
                boolean bl2 = string.toLowerCase().startsWith("t");
                bl = bl2 ^ this.control.getBoolean(xMLProperty.getPropertyName());
                this.control.setValue(xMLProperty.getPropertyName(), bl2);
            } else if (string2.equals("object") && (xMLControl = this.control.getChildControl(xMLProperty.getPropertyName())).getObjectClass() == Character.class && string.length() == 1) {
                Character c = new Character(string.charAt(0));
                bl = !c.equals(this.control.getObject(xMLProperty.getPropertyName()));
                this.control.setValue(xMLProperty.getPropertyName(), c);
            }
        }
        if (bl) {
            this.fireTableCellUpdated(n, n2);
        }
    }
}

