/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.axes.AbstractAxes;
import org.opensourcephysics.display.axes.PolarAxes;

public abstract class AbstractPolarAxis
extends AbstractAxes
implements PolarAxes {
    static final double LOG10 = Math.log(10.0);
    static int MAJOR_TIC = 5;
    protected double dr = 1.0;
    protected double dtheta = 0.39269908169872414;
    protected boolean autospaceRings = true;

    protected AbstractPolarAxis(DrawingPanel drawingPanel) {
        super(drawingPanel);
    }

    public void autospaceRings(boolean bl) {
        this.autospaceRings = bl;
    }

    public double getDeltaR() {
        return this.dr;
    }

    public void setDeltaR(double d) {
        this.dr = d;
    }

    public double getDeltaTheta() {
        return this.dtheta;
    }

    public void setDeltaTheta(double d) {
        this.dtheta = Math.abs(d);
    }

    public void setLabelFormat(String string) {
        this.labelFormat = new DecimalFormat(string);
    }

    protected void drawRAxis(double d, double d2, DrawingPanel drawingPanel, Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics.setColor(this.gridcolor.darker());
        int n = drawingPanel.xToPix(0.0);
        int n2 = drawingPanel.yToPix(0.0);
        int n3 = drawingPanel.xToPix(d2);
        graphics.drawLine(n, n2, Math.min(n3, drawingPanel.getWidth() - drawingPanel.getRightGutter()), n2);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n4 = (int)(drawingPanel.getXMax() / d / (double)MAJOR_TIC);
        int n5 = n4 > 3 ? 2 : 1;
        double d3 = Math.min(d2, drawingPanel.getXMax());
        double d4 = n4 > 3 ? (double)(n5 * MAJOR_TIC) * d : (double)MAJOR_TIC * d;
        while (d4 <= d3) {
            String string = this.getLabel(d4);
            int n6 = fontMetrics.stringWidth(string) + 4;
            int n7 = fontMetrics.getHeight();
            graphics2D.setColor(new Color(247, 247, 247));
            int n8 = drawingPanel.xToPix(d4);
            int n9 = drawingPanel.yToPix(0.0);
            graphics2D.fill(new Rectangle2D.Double(n8 - n6 / 2, n9 + 3, n6, n7));
            graphics2D.setColor(Color.black);
            graphics2D.draw(new Rectangle2D.Double(n8 - n6 / 2, n9 + 3, n6, n7));
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(string, n8 - n6 / 2 + 2, n9 + 1 + n7);
            d4 += (double)(n5 * MAJOR_TIC) * d;
        }
    }

    String getLabel(double d) {
        if (d >= 10.0) {
            return Integer.toString((int)d);
        }
        return Double.toString(d);
    }

    public double drawRings(double d, DrawingPanel drawingPanel, Graphics graphics) {
        int n;
        double d2 = Math.max(this.dr, 1.0E-9);
        if (this.autospaceRings) {
            double d3;
            n = (int)(Math.log(d) / LOG10);
            d2 = d3 = Math.pow(10.0, n - 1);
            while (d / d2 > (double)(5 * MAJOR_TIC)) {
                if (!((d2 *= 2.0) / d3 > 3.5) || !(d2 / d3 < 4.5)) continue;
                d2 = 5.0 * d3;
                d3 *= 10.0;
            }
        } else {
            n = (int)(d / d2);
            while (n > 10 * MAJOR_TIC) {
                n = (int)(d / (d2 *= 2.0));
            }
        }
        n = drawingPanel.xToPix(0.0);
        int n2 = drawingPanel.yToPix(0.0);
        int n3 = (int)(drawingPanel.getXPixPerUnit() * d);
        int n4 = (int)(drawingPanel.getYPixPerUnit() * d);
        if (this.interiorColor != null) {
            graphics.setColor(this.interiorColor);
            graphics.fillOval(n - n3, n2 - n4, 2 * n3, 2 * n4);
        }
        int n5 = 0;
        double d4 = 0.0;
        while (d4 <= d) {
            graphics.setColor(this.gridcolor);
            n3 = drawingPanel.xToPix(d4) - n;
            n4 = n2 - drawingPanel.yToPix(d4);
            if (n5 % MAJOR_TIC == 0) {
                graphics.setColor(this.gridcolor.darker());
            }
            graphics.drawOval(n - n3, n2 - n4, 2 * n3, 2 * n4);
            ++n5;
            d4 += d2;
        }
        return d2;
    }

    public void drawSpokes(double d, DrawingPanel drawingPanel, Graphics graphics) {
        graphics.setColor(this.gridcolor);
        double d2 = 0.0;
        while (d2 < Math.PI) {
            int n = drawingPanel.xToPix(d * Math.cos(d2));
            int n2 = drawingPanel.yToPix(d * Math.sin(d2));
            int n3 = drawingPanel.xToPix(-d * Math.cos(d2));
            int n4 = drawingPanel.yToPix(-d * Math.sin(d2));
            graphics.drawLine(n, n2, n3, n4);
            d2 += this.dtheta;
        }
    }
}

