/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.drawing2d.ElementSegment;

public class ElementArrow
extends ElementSegment {
    public static final int ARROW = 0;
    public static final int SEGMENT = 1;
    public static final int BOX = 2;
    private int arrowType = 0;
    private static final double ARROW_CST = 0.35;
    private static final double ARROW_MAX = 25.0;
    private int headPoints;
    private int[] headA;
    private int[] headB;

    public ElementArrow() {
        this.setSize(new double[]{0.1, 0.1});
        this.setArrowType(0);
        this.getStyle().setRelativePosition(5);
        this.headPoints = 0;
        this.headA = new int[7];
        this.headB = new int[7];
    }

    public void setArrowType(int n) {
        this.arrowType = n;
        this.setNeedToProject(true);
    }

    public int getArrowType() {
        return this.arrowType;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.isReallyVisible()) {
            return;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        this.drawHead((Graphics2D)graphics, this.getStyle().getLineColor(), this.getStyle().getFillColor());
    }

    protected void projectPoints() {
        super.projectPoints();
        if (this.arrowType == 1) {
            this.headPoints = 2;
            this.headA[0] = (int)this.pixelOrigin[0];
            this.headB[0] = (int)this.pixelOrigin[1];
            this.headA[1] = (int)this.pixelEnd[0];
            this.headB[1] = (int)this.pixelEnd[1];
            return;
        }
        double d = this.pixelEnd[0] - this.pixelOrigin[0];
        double d2 = this.pixelEnd[1] - this.pixelOrigin[1];
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 == 0.0) {
            this.headPoints = 2;
            this.headA[0] = (int)this.pixelOrigin[0];
            this.headB[0] = (int)this.pixelOrigin[1];
            this.headA[1] = (int)this.pixelEnd[0];
            this.headB[1] = (int)this.pixelEnd[1];
            return;
        }
        d = 0.35 * d / d3;
        d2 = 0.35 * d2 / d3;
        if (d3 > 25.0) {
            d *= 25.0 / d3;
            d2 *= 25.0 / d3;
        }
        double d4 = this.pixelEnd[0] - d * d3;
        double d5 = this.pixelEnd[1] - d2 * d3;
        d *= d3 / 2.0;
        d2 *= d3 / 2.0;
        switch (this.arrowType) {
            default: {
                this.headPoints = 6;
                this.headA[0] = (int)d4;
                this.headB[0] = (int)d5;
                this.headA[1] = (int)(d4 - d2);
                this.headB[1] = (int)(d5 + d);
                this.headA[2] = (int)this.pixelEnd[0];
                this.headB[2] = (int)this.pixelEnd[1];
                this.headA[3] = (int)(d4 + d2);
                this.headB[3] = (int)(d5 - d);
                this.headA[4] = (int)d4;
                this.headB[4] = (int)d5;
                break;
            }
            case 2: {
                this.headPoints = 7;
                this.headA[0] = (int)d4;
                this.headB[0] = (int)d5;
                this.headA[1] = (int)(d4 - d2);
                this.headB[1] = (int)(d5 + d);
                this.headA[2] = (int)(this.pixelEnd[0] - d2);
                this.headB[2] = (int)(this.pixelEnd[1] + d);
                this.headA[3] = (int)(this.pixelEnd[0] + d2);
                this.headB[3] = (int)(this.pixelEnd[1] - d);
                this.headA[4] = (int)(d4 + d2);
                this.headB[4] = (int)(d5 - d);
                this.headA[5] = (int)d4;
                this.headB[5] = (int)d5;
            }
        }
        int n = this.headPoints - 1;
        this.headA[n] = (int)this.pixelOrigin[0];
        this.headB[n] = (int)this.pixelOrigin[1];
    }

    private void drawHead(Graphics2D graphics2D, Color color, Color color2) {
        graphics2D.setStroke(this.getStyle().getLineStroke());
        if (this.headPoints > 2 && color2 != null && this.getStyle().isDrawingFill()) {
            graphics2D.setPaint(color2);
            graphics2D.fillPolygon(this.headA, this.headB, this.headPoints - 1);
        }
        graphics2D.setColor(color);
        graphics2D.drawPolyline(this.headA, this.headB, this.headPoints);
    }
}

