/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.TextPanel;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.VidCartesianCoordinateStringBuilder;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoPanel
extends InteractivePanel
implements PropertyChangeListener {
    protected static int defaultWidth = 640;
    protected static int defaultHeight = 480;
    public boolean changed = false;
    public String defaultFileName;
    protected VideoPlayer player;
    protected TextPanel mousePanel;
    protected TextPanel messagePanel;
    protected Video video = null;
    protected boolean playerVisible = true;
    protected boolean drawingInImageSpace = false;
    protected double imageWidth;
    protected double imageHeight;
    protected double xOffset;
    protected double yOffset;
    protected double imageBorder;
    protected ImageCoordSystem coords;
    protected Point2D pt = new Point2D.Double();
    protected File dataFile;
    protected Map<String, Class<? extends Filter>> filterClasses = new TreeMap<String, Class<? extends Filter>>();

    public VideoPanel() {
        this((Video)null);
    }

    public VideoPanel(Video video) {
        this.setSquareAspect(true);
        this.player = new VideoPlayer(this);
        this.player.addPropertyChangeListener("videoclip", this);
        this.player.addPropertyChangeListener("stepnumber", this);
        this.player.addPropertyChangeListener("frameduration", this);
        this.add((Component)this.player, "South");
        VideoClip videoClip = this.player.getVideoClip();
        videoClip.addPropertyChangeListener("startframe", this);
        videoClip.addPropertyChangeListener("stepsize", this);
        videoClip.addPropertyChangeListener("stepcount", this);
        videoClip.addPropertyChangeListener("starttime", this);
        this.mousePanel = this.blMessageBox;
        this.messagePanel = this.brMessageBox;
        this.setCoordinateStringBuilder(new VidCartesianCoordinateStringBuilder());
        this.coords = new ImageCoordSystem();
        this.setVideo(video);
        if (video != null && video.getImage().getWidth() > 0) {
            this.setImageWidth(video.getImage().getWidth());
            this.setImageHeight(video.getImage().getHeight());
        } else {
            this.setImageWidth(defaultWidth);
            this.setImageHeight(defaultHeight);
        }
        int n = (int)this.getImageWidth();
        int n2 = (int)this.getImageHeight();
        this.setPreferredSize(new Dimension(n, n2 + this.player.height));
        this.coords.setAllOriginsXY(this.imageWidth / 2.0, this.imageHeight / 2.0);
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                VideoPanel.this.hideMouseBox();
            }
        });
    }

    public void setVideo(Video video) {
        if (video == this.video) {
            return;
        }
        Video video2 = this.video;
        this.getPlayer().setVideoClip(new VideoClip(video));
        if (video2 != null) {
            video2.dispose();
        }
    }

    public Video getVideo() {
        return this.video;
    }

    public double getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(double d) {
        BufferedImage bufferedImage;
        if (this.video != null && (bufferedImage = this.video.getImage()) != null) {
            d = Math.max(d, (double)bufferedImage.getWidth());
        }
        this.imageWidth = d;
    }

    public double getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(double d) {
        BufferedImage bufferedImage;
        if (this.video != null && (bufferedImage = this.video.getImage()) != null) {
            d = Math.max(d, (double)bufferedImage.getHeight());
        }
        this.imageHeight = d;
    }

    public double getImageBorder() {
        return this.imageBorder;
    }

    public void setImageBorder(double d) {
        this.imageBorder = Math.max(d, 0.0);
    }

    public void setCoords(ImageCoordSystem imageCoordSystem) {
        if (this.video != null) {
            this.video.setCoords(imageCoordSystem);
        } else {
            this.coords = imageCoordSystem;
        }
    }

    public ImageCoordSystem getCoords() {
        return this.coords;
    }

    public void setDataFile(File file) {
        File file2 = this.dataFile;
        this.dataFile = file;
        if (file != null) {
            this.defaultFileName = XML.forwardSlash(file.getName());
        }
        this.firePropertyChange("datafile", file2, this.dataFile);
        OSPLog.fine("Data file: " + file);
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public String getFilePath() {
        return this.defaultFileName;
    }

    public void setDrawingInImageSpace(boolean bl) {
        this.drawingInImageSpace = bl;
        if (bl) {
            this.setAutoscaleX(false);
            this.setAutoscaleY(false);
        } else {
            this.setAutoscaleX(true);
            this.setAutoscaleY(true);
        }
        this.firePropertyChange("imagespace", null, new Boolean(bl));
        this.repaint();
    }

    public boolean isDrawingInImageSpace() {
        return this.drawingInImageSpace;
    }

    public VideoPlayer getPlayer() {
        return this.player;
    }

    public void setPlayerVisible(final boolean bl) {
        if (bl == this.playerVisible) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                VideoPanel.this.playerVisible = bl;
                if (VideoPanel.this.playerVisible) {
                    VideoPanel.this.add((Component)VideoPanel.this.player, "South");
                } else {
                    VideoPanel.this.remove(VideoPanel.this.player);
                }
                VideoPanel.this.repaint();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public boolean isPlayerVisible() {
        return this.playerVisible;
    }

    public int getStepNumber() {
        return this.getPlayer().getStepNumber();
    }

    public int getFrameNumber() {
        return this.getPlayer().getFrameNumber();
    }

    @Override
    public ArrayList<Drawable> getDrawables() {
        ArrayList<Drawable> arrayList = super.getDrawables();
        if (this.isDrawingInImageSpace()) {
            for (Drawable drawable : arrayList) {
                if (Trackable.class.isInstance(drawable)) continue;
                arrayList.remove(drawable);
            }
        }
        return arrayList;
    }

    @Override
    public synchronized void addDrawable(Drawable drawable) {
        if (drawable == null) {
            return;
        }
        if (drawable instanceof Video) {
            this.setVideo((Video)drawable);
        } else {
            super.addDrawable(drawable);
        }
        this.repaint();
    }

    @Override
    public synchronized void removeDrawable(Drawable drawable) {
        if (drawable == this.video) {
            this.setVideo(null);
        } else {
            super.removeDrawable(drawable);
        }
    }

    @Override
    public synchronized <T extends Drawable> void removeObjectsOfClass(Class<T> clazz) {
        if (this.video.getClass() == clazz) {
            this.setVideo(null);
        } else {
            super.removeObjectsOfClass(clazz);
        }
    }

    @Override
    public synchronized void clear() {
        super.clear();
        if (this.video != null) {
            super.addDrawable(this.video);
        }
    }

    public void addFilter(Class<? extends Filter> clazz) {
        if (Filter.class.isAssignableFrom(clazz)) {
            String string = clazz.getName();
            this.filterClasses.put(string, clazz);
            this.firePropertyChange("filterClass", null, clazz);
        }
    }

    public void removeFilter(Class<?> clazz) {
        String string;
        Class<? extends Filter> clazz2;
        if (Filter.class.isAssignableFrom(clazz) && (clazz2 = this.filterClasses.remove(string = clazz.getName())) != null) {
            this.firePropertyChange("filterClass", clazz, null);
        }
    }

    public Map<String, Class<? extends Filter>> getFilters() {
        return this.filterClasses;
    }

    public boolean isShowCoordinates() {
        return this.showCoordinates;
    }

    public void hideMouseBox() {
        if (this.mousePanel.isVisible()) {
            this.mousePanel.setText(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("size")) {
            Dimension dimension = (Dimension)propertyChangeEvent.getNewValue();
            this.setImageWidth(dimension.width);
            this.setImageHeight(dimension.height);
        } else if (string.equals("coords")) {
            this.coords = this.video.getCoords();
        } else if (string.equals("image") || string.equals("videoVisible")) {
            this.repaint();
        } else if (string.equals("stepnumber")) {
            this.repaint();
        } else if (string.equals("videoclip")) {
            VideoClip videoClip = (VideoClip)propertyChangeEvent.getOldValue();
            videoClip.removePropertyChangeListener("startframe", this);
            videoClip.removePropertyChangeListener("stepsize", this);
            videoClip.removePropertyChangeListener("stepcount", this);
            videoClip.removePropertyChangeListener("starttime", this);
            VideoClip videoClip2 = (VideoClip)propertyChangeEvent.getNewValue();
            videoClip2.addPropertyChangeListener("startframe", this);
            videoClip2.addPropertyChangeListener("stepsize", this);
            videoClip2.addPropertyChangeListener("stepcount", this);
            videoClip2.addPropertyChangeListener("starttime", this);
            if (this.video != null) {
                this.video.removePropertyChangeListener("coords", this);
                this.video.removePropertyChangeListener("image", this);
                this.video.removePropertyChangeListener("videoVisible", this);
                this.video.removePropertyChangeListener("size", this);
                super.removeDrawable(this.video);
            }
            this.video = videoClip2.getVideo();
            if (this.video != null) {
                this.video.addPropertyChangeListener("coords", this);
                this.video.addPropertyChangeListener("image", this);
                this.video.addPropertyChangeListener("videoVisible", this);
                this.video.addPropertyChangeListener("size", this);
                if (this.video.isMeasured()) {
                    this.coords = this.video.getCoords();
                } else {
                    this.video.setCoords(this.coords);
                }
                Object object = this.drawableList;
                synchronized (object) {
                    this.drawableList.add(0, this.video);
                }
                object = this.video.getImage();
                if (object != null) {
                    this.setImageWidth(((BufferedImage)object).getWidth());
                    this.setImageHeight(((BufferedImage)object).getHeight());
                }
            }
            this.repaint();
        }
    }

    @Override
    protected void paintEverything(Graphics graphics) {
        if (this.playerVisible) {
            this.bottomGutter += this.player.height;
        }
        super.paintEverything(graphics);
        if (this.playerVisible) {
            this.bottomGutter -= this.player.height;
        }
    }

    @Override
    protected void scale(ArrayList<Drawable> arrayList) {
        if (this.drawingInImageSpace) {
            this.xminPreferred = -this.imageBorder * this.imageWidth + this.xOffset;
            this.xmaxPreferred = this.imageWidth + this.imageBorder * this.imageWidth + this.xOffset;
            this.yminPreferred = this.imageHeight + this.imageBorder * this.imageHeight + this.yOffset;
            this.ymaxPreferred = -this.imageBorder * this.imageHeight + this.yOffset;
        }
        super.scale(arrayList);
    }

    protected boolean checkImage() {
        Dimension dimension = this.getSize();
        if (this.playerVisible) {
            dimension.height -= this.player.height;
        }
        if (dimension.width <= 2 || dimension.height <= 2) {
            return false;
        }
        if (this.offscreenImage == null || dimension.width != this.offscreenImage.getWidth() || dimension.height != this.offscreenImage.getHeight()) {
            this.offscreenImage = new BufferedImage(dimension.width, dimension.height, 1);
        }
        return this.offscreenImage != null;
    }

    public Point2D getWorldMousePoint() {
        this.pt.setLocation(this.getMouseX(), this.getMouseY());
        if (this.isDrawingInImageSpace()) {
            int n = this.getFrameNumber();
            AffineTransform affineTransform = this.getCoords().getToWorldTransform(n);
            affineTransform.transform(this.pt, this.pt);
        }
        return this.pt;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            VideoPanel videoPanel = (VideoPanel)object;
            xMLControl.setValue("videoclip", videoPanel.getPlayer().getVideoClip());
            xMLControl.setValue("coords", videoPanel.getCoords());
            ArrayList<Drawable> arrayList = videoPanel.getDrawables();
            arrayList.remove(videoPanel.getVideo());
            if (!arrayList.isEmpty()) {
                xMLControl.setValue("drawables", arrayList);
            }
        }

        public Object createObject(XMLControl xMLControl) {
            return new VideoPanel();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            VideoPanel videoPanel = (VideoPanel)object;
            VideoClip videoClip = (VideoClip)xMLControl.getObject("videoclip");
            if (videoClip != null) {
                videoPanel.getPlayer().setVideoClip(videoClip);
            }
            videoPanel.setCoords((ImageCoordSystem)xMLControl.getObject("coords"));
            Collection collection = (Collection)xMLControl.getObject("drawables");
            if (collection != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    videoPanel.addDrawable((Drawable)iterator.next());
                }
            }
            return object;
        }
    }
}

