/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.FunctionDrawer;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.display.dialogs.ScaleInspector;
import org.opensourcephysics.tools.DataRefreshTool;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolPropsTable;
import org.opensourcephysics.tools.DataToolStatsTable;
import org.opensourcephysics.tools.DataToolTable;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.FitFunctionPanel;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class DataToolTab
extends JPanel {
    static Color[] colors = new Color[]{Color.green.darker(), Color.red, Color.cyan.darker(), Color.yellow.darker(), Color.blue};
    protected DataTool dataTool;
    protected Data owner;
    protected DatasetManager dataManager = new DatasetManager();
    protected JSplitPane[] splitPanes;
    protected DataToolPlotter plot;
    protected DataToolTable dataTable;
    protected DataToolStatsTable statsTable;
    protected DataToolPropsTable propsTable;
    protected JScrollPane statsScroller;
    protected JScrollPane propsScroller;
    protected JToolBar toolbar;
    protected JCheckBox statsCheckbox;
    protected JCheckBox bottomPaneCheckbox;
    protected JCheckBox propsCheckbox;
    protected DatasetCurveFitter curveFitter;
    protected JButton dataBuilderButton;
    protected JButton newColumnButton;
    protected JButton refreshDataButton;
    protected SelectionBox selectionBox = new SelectionBox();
    protected Point zoomPoint;
    protected Action bottomPaneAction;
    protected Action propsAndStatsAction;
    protected String fileName;
    protected JButton helpButton;
    protected int colorIndex;
    protected boolean tabChanged;
    protected boolean userEditable;
    protected UndoableEditSupport undoSupport;
    protected UndoManager undoManager;

    public DataToolTab(Data data, DataTool dataTool) {
        this.dataTool = dataTool;
        this.dataTable = new DataToolTable(this);
        this.createGUI();
        this.addData(data);
        this.refreshGUI();
        this.tabChanged(false);
    }

    public boolean addData(Data data) {
        if (data == null) {
            return false;
        }
        boolean bl = false;
        ArrayList<Dataset> arrayList = data.getDatasets();
        if (arrayList != null && arrayList.size() > 0) {
            Dataset dataset = arrayList.get(0);
            int n = dataset.getXPoints().length;
            double[] dArray = DataTool.getRowArray(n);
            if (this.dataManager.getDatasets().isEmpty()) {
                this.owner = data;
                for (final Dataset dataset2 : arrayList) {
                    Object object;
                    if (dataset2 == null) continue;
                    double[] dArray2 = dataset2.getXPoints();
                    double[] dArray3 = dataset2.getYPoints();
                    XMLControlElement xMLControlElement = new XMLControlElement(dataset2);
                    if (this.dataManager.getDatasets().isEmpty()) {
                        object = new HighlightableDataset();
                        xMLControlElement.loadObject(object, true, true);
                        ((Dataset)object).clear();
                        if (!dataset2.getXColumnName().equals(DataTable.rowName)) {
                            ((Dataset)object).setXYColumnNames(DataTable.rowName, dataset2.getXColumnName());
                            ((Dataset)object).append(dArray, dArray2);
                            ((Dataset)object).setID(((Dataset)object).getID() + 1);
                        } else {
                            ((Dataset)object).setXYColumnNames(DataTable.rowName, dataset2.getYColumnName());
                            ((Dataset)object).append(dArray, dArray3);
                        }
                        ((Dataset)object).setXColumnVisible(false);
                        this.dataManager.addDataset((Dataset)object);
                    }
                    if (this.isDuplicateColumn(dataset2.getXColumnName(), dArray2) && !this.isDuplicateColumn(dataset2.getYColumnName(), dArray3)) {
                        object = new HighlightableDataset();
                        xMLControlElement.loadObject(object, true, true);
                        ((Dataset)object).setXYColumnNames(DataTable.rowName, dataset2.getYColumnName());
                        ((Dataset)object).clear();
                        ((Dataset)object).append(dArray, dArray3);
                        ((Dataset)object).setXColumnVisible(false);
                        this.dataManager.addDataset((Dataset)object);
                        continue;
                    }
                    if (this.isDuplicateColumn(dataset2.getXColumnName(), dArray2) || this.isDuplicateColumn(dataset2.getYColumnName(), dataset2.getYPoints())) continue;
                    object = new Runnable(){

                        public synchronized void run() {
                            DataToolTab.this.dataTool.addTab(dataset2, dataset2.getName());
                        }
                    };
                    SwingUtilities.invokeLater((Runnable)object);
                }
                bl = true;
            } else {
                for (Dataset dataset3 : arrayList) {
                    String string = null;
                    if (this.isDuplicateColumn(dataset3.getXColumnName(), dataset3.getXPoints()) && !this.isDuplicateColumn(dataset3.getYColumnName(), dataset3.getYPoints())) {
                        string = "y";
                    } else if (this.isDuplicateColumn(dataset3.getYColumnName(), dataset3.getYPoints()) && !this.isDuplicateColumn(dataset3.getXColumnName(), dataset3.getXPoints())) {
                        string = "x";
                    }
                    if (string == null) continue;
                    HighlightableDataset highlightableDataset = new HighlightableDataset();
                    XMLControlElement xMLControlElement = new XMLControlElement(dataset3);
                    xMLControlElement.loadObject(highlightableDataset, true, true);
                    double[] dArray4 = string.equals("x") ? dataset3.getXPoints() : dataset3.getYPoints();
                    highlightableDataset.setXColumnVisible(false);
                    ((Dataset)highlightableDataset).clear();
                    ((Dataset)highlightableDataset).append(dArray, dArray4);
                    String string2 = string.equals("x") ? dataset3.getXColumnName() : dataset3.getYColumnName();
                    string2 = this.getUniqueYColumnName(highlightableDataset, string2, false);
                    highlightableDataset.setXYColumnNames(DataTable.rowName, string2);
                    if (string.equals("x")) {
                        highlightableDataset.setID(highlightableDataset.getID() + 1);
                    }
                    this.dataManager.addDataset(highlightableDataset);
                    this.dataTable.getWorkingData(string2);
                    bl = true;
                }
            }
            this.dataTable.refreshTable();
            this.statsTable.refreshStatistics();
            this.refreshGUI();
            this.refreshPlot();
        }
        if (bl) {
            this.tabChanged(true);
        }
        return bl;
    }

    public void setXYColumns(String string, String string2) {
        this.dataTable.setWorkingColumns(string, string2);
    }

    public void setConnected(String string, boolean bl) {
        DataToolTable.WorkingDataset workingDataset = this.dataTable.workingMap.get(string);
        if (workingDataset != null) {
            workingDataset.setConnected(bl);
        }
    }

    public void setMarkersVisible(String string, boolean bl) {
        DataToolTable.WorkingDataset workingDataset = this.dataTable.workingMap.get(string);
        if (workingDataset != null) {
            workingDataset.setMarkersVisible(bl);
        }
    }

    public void setName(String string) {
        super.setName(string);
        this.curveFitter.setDataSourceName(string);
    }

    protected void setFontLevel(int n) {
        FontSizer.setFonts(this.statsTable, n);
        FontSizer.setFonts(this.propsTable, n);
        this.curveFitter.setFontLevel(n);
        double d = FontSizer.getFactor(n);
        this.plot.getAxes().resizeFonts(d, this.plot);
        FontSizer.setFonts(this.plot.getPopupMenu(), n);
        if (this.propsTable.styleDialog != null) {
            FontSizer.setFonts(this.propsTable.styleDialog, n);
            this.propsTable.styleDialog.pack();
        }
        Runnable runnable = new Runnable(){

            public void run() {
                DataToolTab.this.bottomPaneAction.actionPerformed(null);
                DataToolTab.this.propsAndStatsAction.actionPerformed(null);
                DataToolTab.this.propsTable.refreshTable();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected void tabChanged(boolean bl) {
        this.tabChanged = bl;
    }

    protected DataToolTable.WorkingDataset getWorkingData() {
        this.dataTable.getSelectedData();
        return this.dataTable.workingData;
    }

    protected Data getOwner() {
        return this.owner;
    }

    protected String getUniqueYColumnName(Dataset dataset, String string, boolean bl) {
        int n;
        if (string == null) {
            return null;
        }
        string = string.replaceAll(" ", "");
        if (bl) {
            n = 0;
            int n2 = 2;
            while (n < n2) {
                ++n;
                if (this.isDuplicateName(dataset, string)) {
                    string = JOptionPane.showInputDialog(this, "\"" + string + "\" " + ToolsRes.getString("DataFunctionPanel.Dialog.DuplicateName.Message"), ToolsRes.getString("DataFunctionPanel.Dialog.DuplicateName.Title"), 2);
                }
                if (string == null || string.equals("")) {
                    return null;
                }
                if (this.isReservedName(string)) {
                    string = JOptionPane.showInputDialog(this, "\"" + string + "\" " + ToolsRes.getString("DataToolTab.Dialog.ReservedName.Message"), ToolsRes.getString("DataToolTab.Dialog.ReservedName.Title"), 2);
                }
                if (string != null && !string.equals("")) continue;
                return null;
            }
        }
        n = 0;
        try {
            Double.parseDouble(string);
            string = ToolsRes.getString("DataToolTab.NewColumn.Name");
        }
        catch (NumberFormatException numberFormatException) {}
        String string2 = string;
        while (this.isDuplicateName(dataset, string2) || this.isReservedName(string2)) {
            string2 = String.valueOf(string) + "_" + ++n;
        }
        return string2;
    }

    protected boolean isDuplicateName(Dataset dataset, String string) {
        if (this.dataManager.getDatasets().isEmpty()) {
            return false;
        }
        if (this.dataManager.getDataset(0).getXColumnName().equals(string)) {
            return true;
        }
        string = TeXParser.removeSubscripting(string);
        for (Dataset dataset2 : this.dataManager.getDatasets()) {
            String string2;
            if (dataset2 == dataset || !(string2 = TeXParser.removeSubscripting(dataset2.getYColumnName())).equals(string)) continue;
            return true;
        }
        return false;
    }

    protected boolean isReservedName(String string) {
        String[] stringArray = FunctionTool.parserNames;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        stringArray = UserFunction.dummyVars;
        n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected void columnNameChanged(String string, String string2) {
        Object object;
        this.tabChanged(true);
        String string3 = this.dataTable.getFormatPattern(string);
        this.dataTable.removeWorkingData(string);
        this.dataTable.getWorkingData(string2);
        this.dataTable.setFormatPattern(string2, string3);
        if (this.propsTable.styleDialog != null && this.propsTable.styleDialog.isVisible() && this.propsTable.styleDialog.getName().equals(string)) {
            this.propsTable.styleDialog.setName(string2);
            object = ToolsRes.getString("DataToolPropsTable.Dialog.Title");
            String string4 = TeXParser.removeSubscripting(string2);
            this.propsTable.styleDialog.setTitle(String.valueOf(object) + " \"" + string4 + "\"");
        }
        if ((object = this.getWorkingData()) == null) {
            return;
        }
        this.refreshPlot();
    }

    protected boolean reloadData(Data data) {
        Object object;
        ArrayList<Dataset> arrayList = this.dataManager.getDatasets();
        if (arrayList != null && !arrayList.isEmpty()) {
            for (Dataset object2 : arrayList) {
                Dataset dataset = this.getMatchingID(object2, data);
                if (dataset == null || dataset == object2) continue;
                object2.clear();
                object2.setName(dataset.getName());
                object = DataTool.getRowArray(dataset.getIndex());
                if (dataset.getXColumnName().equals(object2.getYColumnName())) {
                    object2.append((double[])object, dataset.getXPoints());
                    continue;
                }
                object2.append((double[])object, dataset.getYPoints());
            }
        }
        arrayList = data.getDatasets();
        boolean bl = false;
        if (arrayList != null) {
            for (Dataset dataset : arrayList) {
                object = this.getMatchingID(dataset, this.dataManager);
                if (object != null) continue;
                DataToolTab dataToolTab = this.dataTool.getTab(dataset);
                if (dataToolTab != null && dataToolTab != this) {
                    this.dataTool.update(dataset);
                    continue;
                }
                boolean bl2 = bl = this.addData(dataset) || bl;
            }
        }
        for (Dataset dataset : this.dataManager.getDatasets()) {
            if (dataset instanceof DataFunction) {
                ((DataFunction)dataset).refreshFunctionData();
                continue;
            }
            this.pad(dataset);
        }
        this.dataTable.trimEmptyRows(0);
        this.refreshPlot();
        this.dataTable.refreshTable();
        this.statsTable.refreshStatistics();
        return bl;
    }

    protected void pad(Dataset dataset) {
        int n = this.dataTable.getRowCount();
        if (dataset instanceof DataFunction) {
            return;
        }
        double[] dArray = dataset.getYPoints();
        if (n > dArray.length) {
            double[] dArray2 = new double[n];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            int n2 = dArray.length;
            while (n2 < n) {
                dArray2[n2] = Double.NaN;
                ++n2;
            }
            double[] dArray3 = DataTool.getRowArray(n);
            dataset.clear();
            dataset.append(dArray3, dArray2);
        }
    }

    protected Dataset createDataset() {
        this.colorIndex %= colors.length;
        Color color = colors[this.colorIndex++];
        Color color2 = color.darker();
        HighlightableDataset highlightableDataset = new HighlightableDataset(color, color2, false);
        int n = Math.max(1, this.dataTable.getRowCount());
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = n2;
            dArray2[n2] = Double.NaN;
            ++n2;
        }
        ((Dataset)highlightableDataset).append(dArray, dArray2);
        highlightableDataset.setXColumnVisible(false);
        return highlightableDataset;
    }

    protected Dataset copy(Dataset dataset, Dataset dataset2, boolean bl) {
        Object object;
        Object object2;
        if (dataset2 == null) {
            dataset2 = new Dataset();
        }
        if (bl) {
            dataset2.clear();
            object2 = dataset.getXPoints();
            object = dataset.getYPoints();
            dataset2.append((double[])object2, (double[])object);
            dataset2.setID(dataset.getID());
        }
        dataset2.setName(dataset.getName());
        dataset2.setXYColumnNames(dataset.getXColumnName(), dataset.getYColumnName());
        dataset2.setMarkerShape(dataset.getMarkerShape());
        dataset2.setMarkerSize(dataset.getMarkerSize());
        object2 = dataset.getFillColor();
        object = dataset.getEdgeColor();
        dataset2.setMarkerColor((Color)object2, (Color)object);
        dataset2.setLineColor(dataset.getLineColor());
        dataset2.setConnected(dataset.isConnected());
        return dataset2;
    }

    protected void createGUI() {
        this.setLayout(new BorderLayout());
        this.splitPanes = new JSplitPane[3];
        this.splitPanes[0] = new JSplitPane(1);
        this.splitPanes[0].setResizeWeight(1.0);
        this.splitPanes[0].setOneTouchExpandable(true);
        this.splitPanes[1] = new JSplitPane(0);
        this.splitPanes[1].setResizeWeight(1.0);
        this.splitPanes[1].setDividerSize(0);
        this.splitPanes[2] = new JSplitPane(0);
        this.splitPanes[2].setDividerSize(0);
        this.splitPanes[2].setEnabled(false);
        this.dataTable.setRowNumberVisible(true);
        JScrollPane jScrollPane = new JScrollPane(this.dataTable);
        this.dataTable.refreshTable();
        this.dataTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                DataToolTable.WorkingDataset workingDataset = DataToolTab.this.dataTable.workingData;
                DataToolTable.WorkingDataset workingDataset2 = DataToolTab.this.getWorkingData();
                if (workingDataset2 != workingDataset) {
                    DataToolTab.this.tabChanged(true);
                    String string = workingDataset2.getXColumnName();
                    if (DataToolTab.this.curveFitter.fitBuilder != null) {
                        Iterator<String> iterator = DataToolTab.this.curveFitter.fitBuilder.getPanelNames().iterator();
                        while (iterator.hasNext()) {
                            FunctionPanel functionPanel = DataToolTab.this.curveFitter.fitBuilder.getPanel(iterator.next().toString());
                            UserFunctionEditor userFunctionEditor = (UserFunctionEditor)functionPanel.getFunctionEditor();
                            userFunctionEditor.setDefaultVariables(new String[]{string});
                            userFunctionEditor.repaint();
                        }
                    }
                }
                if (workingDataset2 == null || workingDataset2 == workingDataset) {
                    return;
                }
                DataToolTab.this.selectionBox.setSize(0, 0);
                DataToolTab.this.refreshPlot();
            }
        });
        ListSelectionModel listSelectionModel = this.dataTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                try {
                    DataToolTab.this.curveFitter.setData(DataToolTab.this.dataTable.getSelectedData());
                }
                catch (Exception exception) {}
            }
        });
        this.bottomPaneAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataToolTab.this.bottomPaneCheckbox == null) {
                    return;
                }
                DataToolTab.this.splitPanes[1].setDividerSize(DataToolTab.this.splitPanes[2].getDividerSize());
                DataToolTab.this.splitPanes[1].setDividerLocation(1.0);
                DataToolTab.this.plot.removeDrawables(FunctionDrawer.class);
                boolean bl = DataToolTab.this.bottomPaneCheckbox.isSelected();
                DataToolTab.this.splitPanes[1].setEnabled(bl);
                if (bl) {
                    int n = DataToolTab.this.splitPanes[1].getDividerLocation();
                    int n2 = DataToolTab.this.curveFitter.getPreferredSize().height;
                    DataToolTab.this.splitPanes[1].setDividerSize(DataToolTab.this.splitPanes[0].getDividerSize());
                    DataToolTab.this.splitPanes[1].setDividerLocation(n - n2 - 10);
                    DataToolTab.this.plot.addDrawable(DataToolTab.this.curveFitter.getDrawer());
                }
                DataToolTab.this.refreshPlot();
            }
        };
        this.bottomPaneCheckbox = new JCheckBox();
        this.bottomPaneCheckbox.setSelected(false);
        this.bottomPaneCheckbox.setOpaque(false);
        this.bottomPaneCheckbox.addActionListener(this.bottomPaneAction);
        this.newColumnButton = DataTool.createButton("");
        this.newColumnButton.addActionListener(new ActionListener(){

            public void actionPerformed(final ActionEvent actionEvent) {
                Dataset dataset = DataToolTab.this.createDataset();
                String string = ToolsRes.getString("DataToolTab.NewColumn.Name");
                string = DataToolTab.this.getUniqueYColumnName(dataset, string, false);
                Object object = JOptionPane.showInputDialog(DataToolTab.this.dataTool, ToolsRes.getString("DataToolTab.Dialog.NameColumn.Message"), ToolsRes.getString("DataToolTab.Dialog.NameColumn.Title"), 3, null, null, string);
                if (object == null) {
                    return;
                }
                String string2 = DataToolTab.this.getUniqueYColumnName(dataset, object.toString(), true);
                if (string2 == null) {
                    return;
                }
                if (string2.equals("")) {
                    String string3 = ToolsRes.getString("DataToolTab.NewColumn.Name");
                    string2 = DataToolTab.this.getUniqueYColumnName(dataset, string3, false);
                }
                OSPLog.finer("adding new column \"" + string2 + "\"");
                dataset.setXYColumnNames(DataTable.rowName, string2);
                DataToolTab.this.addData(dataset);
                DataToolTab.this.dataTable.refreshTable();
                DataToolTab.this.refreshPlot();
                DataToolTab.this.refreshGUI();
                int n = DataToolTab.this.dataTable.getColumnCount() - 1;
                DataToolTable dataToolTable = DataToolTab.this.dataTable;
                dataToolTable.getClass();
                DataToolTable.TableEdit tableEdit = dataToolTable.new DataToolTable.TableEdit(1, string2, new Integer(n), dataset);
                DataToolTab.this.undoSupport.postEdit(tableEdit);
                DataToolTab.this.dataTable.refreshUndoItems();
                Runnable runnable = new Runnable(){

                    public synchronized void run() {
                        int n = (this).DataToolTab.this.dataTable.getColumnCount() - 1;
                        (this).DataToolTab.this.dataTable.changeSelection(0, n, false, false);
                        (this).DataToolTab.this.dataTable.editCellAt(0, n, actionEvent);
                        (this).DataToolTab.this.dataTable.editor.field.requestFocus();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        this.dataBuilderButton = DataTool.createButton(ToolsRes.getString("DataToolTab.Button.DataBuilder.Text"));
        this.dataBuilderButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.DataBuilder.Tooltip"));
        this.dataBuilderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataToolTab.this.dataTool != null) {
                    DataToolTab.this.dataTool.getDataFunctionTool().setSelectedPanel(DataToolTab.this.getName());
                    DataToolTab.this.dataTool.getDataFunctionTool().setVisible(true);
                }
            }
        });
        this.refreshDataButton = DataTool.createButton(ToolsRes.getString("DataToolTab.Button.Refresh.Text"));
        this.refreshDataButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.Refresh.Tooltip"));
        this.refreshDataButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataToolTab.this.dataTool != null) {
                    DataToolTab.this.dataManager.setName(DataToolTab.this.getName());
                    DataToolTab.this.dataTool.jobManager.sendReplies(DataToolTab.this.dataManager);
                }
            }
        });
        this.helpButton = DataTool.createButton(ToolsRes.getString("Tool.Button.Help"));
        this.helpButton.setToolTipText(ToolsRes.getString("Tool.Button.Help.ToolTip"));
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataToolTab.this.dataTool != null) {
                    DataToolTab.this.dataTool.helpItem.doClick();
                }
            }
        });
        this.propsAndStatsAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                boolean bl = DataToolTab.this.statsCheckbox.isSelected();
                boolean bl2 = DataToolTab.this.propsCheckbox.isSelected();
                if (bl) {
                    DataToolTab.this.statsTable.refreshStatistics();
                }
                int n2 = DataToolTab.this.statsTable.getPreferredSize().height;
                int n3 = DataToolTab.this.propsTable.getPreferredSize().height;
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                int n4 = n = lookAndFeel.getClass().getName().indexOf("Nimbus") > -1 ? 8 : 4;
                if (bl && bl2) {
                    Box box = Box.createVerticalBox();
                    box.add(DataToolTab.this.statsScroller);
                    box.add(DataToolTab.this.propsScroller);
                    DataToolTab.this.splitPanes[2].setTopComponent(box);
                    DataToolTab.this.splitPanes[2].setDividerLocation(n2 + n3 + 2 * n);
                } else if (bl) {
                    DataToolTab.this.splitPanes[2].setTopComponent(DataToolTab.this.statsScroller);
                    DataToolTab.this.splitPanes[2].setDividerLocation(n2 + n);
                } else if (bl2) {
                    DataToolTab.this.splitPanes[2].setTopComponent(DataToolTab.this.propsScroller);
                    DataToolTab.this.splitPanes[2].setDividerLocation(n3 + n);
                } else {
                    DataToolTab.this.splitPanes[2].setDividerLocation(0);
                }
            }
        };
        this.statsCheckbox = new JCheckBox(ToolsRes.getString("Checkbox.Statistics.Label"), false);
        this.statsCheckbox.setOpaque(false);
        this.statsCheckbox.setToolTipText(ToolsRes.getString("Checkbox.Statistics.ToolTip"));
        this.statsCheckbox.addActionListener(this.propsAndStatsAction);
        this.propsCheckbox = new JCheckBox(ToolsRes.getString("DataToolTab.Checkbox.Properties.Text"), true);
        this.propsCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Properties.Tooltip"));
        this.propsCheckbox.setOpaque(false);
        this.propsCheckbox.addActionListener(this.propsAndStatsAction);
        this.plot = new DataToolPlotter(this.getWorkingData());
        if (this.getWorkingData() != null) {
            this.plot.addDrawable(this.getWorkingData());
            this.plot.setTitle(this.getWorkingData().getName());
        }
        this.plot.addDrawable(this.selectionBox);
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            Set<Integer> rowsInside = new HashSet<Integer>();

            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                DataToolTab.this.selectionBox.xstart = point.x;
                DataToolTab.this.selectionBox.ystart = point.y;
                this.rowsInside.clear();
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    if (DataToolTab.this.selectionBox.isZoomable()) {
                        DataToolTab.this.plot.getZoomInItem().setText(ToolsRes.getString("MenuItem.ZoomToBox"));
                    } else {
                        DataToolTab.this.zoomPoint = mouseEvent.getPoint();
                        DataToolTab.this.plot.getZoomInItem().setText(ToolsRes.getString("MenuItem.ZoomIn"));
                    }
                } else {
                    DataToolTab.this.selectionBox.setSize(0, 0);
                }
                if (!(mouseEvent.isControlDown() || mouseEvent.isShiftDown() || OSPRuntime.isPopupTrigger(mouseEvent))) {
                    DataToolTab.this.dataTable.clearSelection();
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                boolean bl;
                boolean bl2 = bl = mouseEvent.getButton() == 3 || mouseEvent.isControlDown() && OSPRuntime.isMac();
                if (bl) {
                    return;
                }
                DataToolTable.WorkingDataset workingDataset = DataToolTab.this.dataTable.getWorkingData();
                if (workingDataset == null) {
                    return;
                }
                Point point = mouseEvent.getPoint();
                DataToolTab.this.selectionBox.visible = true;
                DataToolTab.this.selectionBox.setSize(point.x - DataToolTab.this.selectionBox.xstart, point.y - DataToolTab.this.selectionBox.ystart);
                double[] dArray = workingDataset.getXPoints();
                double[] dArray2 = workingDataset.getYPoints();
                int n = 0;
                while (n < dArray.length) {
                    double d = DataToolTab.this.plot.xToPix(dArray[n]);
                    double d2 = DataToolTab.this.plot.yToPix(dArray2[n]);
                    Integer n2 = DataToolTab.this.dataTable.workingRows.get(new Integer(n));
                    int n3 = n2;
                    if (DataToolTab.this.selectionBox.contains(d, d2)) {
                        if (!this.rowsInside.contains(n2)) {
                            this.rowsInside.add(n2);
                            DataToolTab.this.dataTable.getSelectionModel().addSelectionInterval(n3, n3);
                            int n4 = DataToolTab.this.dataTable.getXColumn();
                            DataToolTab.this.dataTable.getColumnModel().getSelectionModel().addSelectionInterval(n4, n4);
                            n4 = DataToolTab.this.dataTable.getYColumn();
                            DataToolTab.this.dataTable.getColumnModel().getSelectionModel().addSelectionInterval(n4, n4);
                        }
                    } else if (this.rowsInside.contains(n2)) {
                        DataToolTab.this.dataTable.getSelectionModel().removeSelectionInterval(n3, n3);
                        this.rowsInside.remove(n2);
                        if (this.rowsInside.isEmpty()) {
                            DataToolTab.this.dataTable.getColumnModel().getSelectionModel().removeSelectionInterval(0, DataToolTab.this.dataTable.getColumnCount() - 1);
                        }
                    }
                    ++n;
                }
                DataToolTab.this.dataTable.getSelectedData();
                DataToolTab.this.plot.repaint();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                DataToolTab.this.plot.repaint();
            }
        };
        this.plot.addMouseListener(mouseInputAdapter);
        this.plot.addMouseMotionListener(mouseInputAdapter);
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.setBorder(BorderFactory.createEtchedBorder());
        this.toolbar.add(this.propsCheckbox);
        this.toolbar.add(this.bottomPaneCheckbox);
        this.toolbar.add(this.statsCheckbox);
        this.toolbar.add(Box.createGlue());
        this.toolbar.add(this.newColumnButton);
        this.toolbar.add(this.dataBuilderButton);
        this.toolbar.add(this.refreshDataButton);
        this.toolbar.add(this.helpButton);
        this.curveFitter = new DatasetCurveFitter(this.getWorkingData());
        this.curveFitter.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("changed")) {
                    DataToolTab.this.tabChanged(true);
                    return;
                }
                if (propertyChangeEvent.getPropertyName().equals("drawer") && DataToolTab.this.bottomPaneCheckbox != null && DataToolTab.this.bottomPaneCheckbox.isSelected()) {
                    DataToolTab.this.plot.removeDrawables(FunctionDrawer.class);
                    DataToolTab.this.plot.addDrawable((FunctionDrawer)propertyChangeEvent.getNewValue());
                }
                DataToolTab.this.plot.repaint();
            }
        });
        this.statsTable = new DataToolStatsTable(this.dataTable);
        this.statsScroller = new JScrollPane(this.statsTable){

            public Dimension getPreferredSize() {
                Dimension dimension = DataToolTab.this.statsTable.getPreferredSize();
                return dimension;
            }
        };
        this.propsTable = new DataToolPropsTable(this.dataTable);
        this.propsTable.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("display")) {
                    DataToolTab.this.refreshPlot();
                }
            }
        });
        this.propsScroller = new JScrollPane(this.propsTable){

            public Dimension getPreferredSize() {
                Dimension dimension = DataToolTab.this.propsTable.getPreferredSize();
                return dimension;
            }
        };
        this.add((Component)this.toolbar, "North");
        this.add((Component)this.splitPanes[0], "Center");
        this.splitPanes[0].setLeftComponent(this.splitPanes[1]);
        this.splitPanes[0].setRightComponent(this.splitPanes[2]);
        this.splitPanes[1].setTopComponent(this.plot);
        this.splitPanes[1].setBottomComponent(this.curveFitter);
        this.splitPanes[2].setBottomComponent(jScrollPane);
        this.undoManager = new UndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(this.undoManager);
    }

    protected void refreshGUI() {
        boolean bl = this.tabChanged;
        this.newColumnButton.setText(ToolsRes.getString("DataToolTab.Button.NewColumn.Text"));
        this.newColumnButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.NewColumn.Tooltip"));
        this.dataBuilderButton.setText(ToolsRes.getString("DataToolTab.Button.DataBuilder.Text"));
        this.dataBuilderButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.DataBuilder.Tooltip"));
        this.dataBuilderButton.setEnabled(this.owner != null);
        this.refreshDataButton.setText(ToolsRes.getString("DataToolTab.Button.Refresh.Text"));
        this.refreshDataButton.setToolTipText(ToolsRes.getString("DataToolTab.Button.Refresh.Tooltip"));
        this.statsCheckbox.setText(ToolsRes.getString("Checkbox.Statistics.Label"));
        this.statsCheckbox.setToolTipText(ToolsRes.getString("Checkbox.Statistics.ToolTip"));
        this.bottomPaneCheckbox.setText(ToolsRes.getString("Checkbox.Fits.Label"));
        this.bottomPaneCheckbox.setToolTipText(ToolsRes.getString("Checkbox.Fits.ToolTip"));
        this.propsCheckbox.setText(ToolsRes.getString("DataToolTab.Checkbox.Properties.Text"));
        this.propsCheckbox.setToolTipText(ToolsRes.getString("DataToolTab.Checkbox.Properties.Tooltip"));
        this.helpButton.setText(ToolsRes.getString("Tool.Button.Help"));
        this.helpButton.setToolTipText(ToolsRes.getString("Tool.Button.Help.ToolTip"));
        this.toolbar.remove(this.newColumnButton);
        if (this.userEditable) {
            int n = this.toolbar.getComponentIndex(this.helpButton);
            this.toolbar.add((Component)this.newColumnButton, n);
            this.toolbar.validate();
        }
        this.toolbar.remove(this.refreshDataButton);
        if (this.dataTool != null) {
            Collection<Tool> collection = this.dataTool.jobManager.getTools(this.dataManager);
            for (Tool tool : collection) {
                if (!(tool instanceof DataRefreshTool)) continue;
                int n = this.toolbar.getComponentIndex(this.helpButton);
                this.toolbar.add((Component)this.refreshDataButton, n);
                this.toolbar.validate();
                break;
            }
        }
        this.curveFitter.refreshGUI();
        this.statsTable.refreshGUI();
        this.propsTable.refreshGUI();
        this.tabChanged = bl;
    }

    protected void init() {
        this.splitPanes[0].setDividerLocation(0.7);
        this.splitPanes[1].setDividerLocation(1.0);
        this.curveFitter.splitPane.setDividerLocation(0.4);
        this.propsAndStatsAction.actionPerformed(null);
        int n = 0;
        while (n < this.dataTable.getColumnCount()) {
            String string = this.dataTable.getColumnName(n);
            this.dataTable.getWorkingData(string);
            ++n;
        }
    }

    private Dataset getMatchingID(Dataset dataset, Data data) {
        ArrayList<Dataset> arrayList = data.getDatasets();
        if (arrayList == null) {
            return null;
        }
        for (Dataset dataset2 : arrayList) {
            int n = dataset2.getID();
            if (dataset2.getYColumnName().equals(dataset.getYColumnName()) && dataset.getID() == n) {
                return dataset2;
            }
            if (!dataset2.getXColumnName().equals(dataset.getYColumnName()) || dataset.getID() != n + 1) continue;
            return dataset2;
        }
        return null;
    }

    protected boolean isDuplicateColumn(String string, double[] dArray) {
        if (string.equals(this.dataTable.getColumnName(0))) {
            return true;
        }
        for (Dataset dataset : this.dataManager.getDatasets()) {
            double[] dArray2 = dataset.getYPoints();
            if (!string.equals(dataset.getYColumnName()) || !this.isDuplicate(dArray, dataset.getYPoints())) continue;
            if (dArray.length > dArray2.length) {
                dataset.clear();
                dataset.append(dArray, dArray);
            }
            return true;
        }
        return false;
    }

    private boolean isDuplicate(double[] dArray, double[] dArray2) {
        int n = Math.min(dArray.length, dArray2.length);
        int n2 = 0;
        while (n2 < n) {
            if (!(Double.isNaN(dArray[n2]) && Double.isNaN(dArray2[n2]) || dArray[n2] == dArray2[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean isOwnedBy(Data data) {
        String string = null;
        try {
            Method method = data.getClass().getMethod("getName", new Class[0]);
            string = (String)method.invoke((Object)data, new Object[0]);
        }
        catch (Exception exception) {}
        if (string != null && string.equals(this.getName())) {
            return true;
        }
        return this.owner != null && data == this.owner;
    }

    protected void refreshPlot() {
        this.curveFitter.setData(this.dataTable.getSelectedData());
        this.plot.removeDrawables(Dataset.class);
        DataToolTable.WorkingDataset workingDataset = this.getWorkingData();
        if (workingDataset != null) {
            Object object2;
            int n = this.dataTable.convertColumnIndexToView(0);
            String string = this.dataTable.getColumnName(n == 0 ? 1 : 0);
            HashMap<String, DataToolTable.WorkingDataset> hashMap = this.dataTable.workingMap;
            for (Object object2 : hashMap.values()) {
                ((DataToolTable.WorkingDataset)object2).setXSource(workingDataset.getXSource());
                String string2 = ((Dataset)object2).getYColumnName();
                if (object2 == workingDataset || string2.equals(string) || !((DataToolTable.WorkingDataset)object2).isMarkersVisible() && !((Dataset)object2).isConnected()) continue;
                ((HighlightableDataset)object2).clearHighlights();
                if (!((DataToolTable.WorkingDataset)object2).isMarkersVisible()) {
                    ((DataToolTable.WorkingDataset)object2).setMarkerShape(0);
                }
                this.plot.addDrawable((Drawable)object2);
            }
            this.plot.addDrawable(workingDataset);
            if (this.bottomPaneCheckbox != null && this.bottomPaneCheckbox.isSelected()) {
                this.plot.removeDrawable(this.curveFitter.getDrawer());
                this.plot.addDrawable(this.curveFitter.getDrawer());
            }
            this.plot.setTitle(workingDataset.getName());
            this.plot.setXLabel(workingDataset.getColumnName(0));
            this.plot.setYLabel(workingDataset.getColumnName(1));
            String string3 = TeXParser.removeSubscripting(workingDataset.getColumnName(1));
            object2 = TeXParser.removeSubscripting(workingDataset.getColumnName(0));
            this.curveFitter.eqnField.setText(String.valueOf(string3) + " = " + this.curveFitter.fit.getExpression((String)object2));
        } else {
            this.plot.setTitle("");
            this.plot.setXLabel("");
            this.plot.setYLabel("");
        }
        if (this.dataTool != null) {
            this.dataTool.refreshTabTitles();
            this.dataTool.helpLabel.setText(this.dataManager.getDatasets().size() < 2 ? null : ToolsRes.getString("DataTool.StatusBar.Help.DragColumns"));
        }
        this.repaint();
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    class DataToolPlotter
    extends PlottingPanel {
        DataToolPlotter(Dataset dataset) {
            super(dataset == null ? "x" : dataset.getColumnName(0), dataset == null ? "y" : dataset.getColumnName(1), "");
            this.setAntialiasShapeOn(true);
        }

        protected JMenuItem getZoomInItem() {
            return this.zoomInItem;
        }

        protected void zoomOut() {
            double d = this.xmax - this.xmin;
            double d2 = this.ymax - this.ymin;
            this.setPreferredMinMax(this.xmin - d / 2.0, this.xmax + d / 2.0, this.ymin - d2 / 2.0, this.ymax + d2 / 2.0);
            this.invalidateImage();
            DataToolTab.this.selectionBox.setSize(0, 0);
            this.repaint();
        }

        protected void zoomIn() {
            int n = DataToolTab.this.selectionBox.getBounds().width;
            int n2 = DataToolTab.this.selectionBox.getBounds().height;
            if (DataToolTab.this.selectionBox.isZoomable()) {
                int n3 = DataToolTab.this.selectionBox.getBounds().x;
                int n4 = DataToolTab.this.selectionBox.getBounds().y;
                double d = this.pixToX(n3);
                double d2 = this.pixToX(n3 + n);
                double d3 = this.pixToY(n4);
                double d4 = this.pixToY(n4 + n2);
                this.setPreferredMinMax(d, d2, d4, d3);
                this.invalidateImage();
                DataToolTab.this.selectionBox.setSize(0, 0);
                this.repaint();
            } else if (DataToolTab.this.zoomPoint != null) {
                double d = this.xmax - this.xmin;
                double d5 = this.ymax - this.ymin;
                double d6 = this.pixToX(DataToolTab.this.zoomPoint.x);
                double d7 = this.pixToY(DataToolTab.this.zoomPoint.y);
                this.setPreferredMinMax(d6 - d / 4.0, d6 + d / 4.0, d7 - d5 / 4.0, d7 + d5 / 4.0);
                this.invalidateImage();
                DataToolTab.this.selectionBox.setSize(0, 0);
                this.repaint();
            }
        }

        protected void buildPopupmenu() {
            this.popupmenu.setEnabled(true);
            this.zoomInItem = new JMenuItem(ToolsRes.getString("MenuItem.ZoomIn"));
            this.zoomInItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.zoomIn();
                }
            });
            this.popupmenu.add(this.zoomInItem);
            this.zoomOutItem = new JMenuItem(ToolsRes.getString("MenuItem.ZoomOut"));
            this.zoomOutItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.zoomOut();
                }
            });
            this.popupmenu.add(this.zoomOutItem);
            JMenuItem jMenuItem = new JMenuItem(ToolsRes.getString("MenuItem.ZoomToFit"));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.setAutoscaleX(true);
                    ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.plot.setAutoscaleY(true);
                    ((DataToolPlotter)DataToolPlotter.this).DataToolTab.this.selectionBox.setSize(0, 0);
                    DataToolTab.this.refreshPlot();
                }
            });
            this.popupmenu.add(jMenuItem);
            this.scaleItem = new JMenuItem(ToolsRes.getString("MenuItem.Scale"));
            this.scaleItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ScaleInspector scaleInspector = new ScaleInspector(DataToolPlotter.this);
                    scaleInspector.setLocationRelativeTo(DataToolPlotter.this);
                    scaleInspector.updateDisplay();
                    scaleInspector.setVisible(true);
                }
            });
            this.popupmenu.add(this.scaleItem);
            this.popupmenu.addSeparator();
            this.snapshotItem = new JMenuItem(ToolsRes.getString("MenuItem.Snapshot"));
            this.snapshotItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataToolPlotter.this.snapshot();
                }
            });
            this.popupmenu.add(this.snapshotItem);
            this.popupmenu.addSeparator();
            this.propertiesItem = new JMenuItem(ToolsRes.getString("MenuItem.Inspect"));
            this.propertiesItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataToolPlotter.this.showInspector();
                }
            });
            this.popupmenu.add(this.propertiesItem);
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        /*
         * WARNING - void declaration
         */
        public void saveObject(XMLControl xMLControl, Object object) {
            String[] stringArray;
            Object object2;
            DataToolTab dataToolTab = (DataToolTab)object;
            xMLControl.setValue("name", dataToolTab.getName());
            DatasetManager datasetManager = new DatasetManager();
            ArrayList<Dataset> arrayList = new ArrayList<Dataset>();
            for (Dataset object32 : dataToolTab.dataManager.getDatasets()) {
                if (object32 instanceof DataFunction) {
                    arrayList.add(object32);
                    continue;
                }
                datasetManager.addDataset(object32);
            }
            xMLControl.setValue("data", datasetManager);
            if (!arrayList.isEmpty()) {
                object2 = arrayList.toArray(new DataFunction[0]);
                xMLControl.setValue("data_functions", object2);
            }
            if (dataToolTab.curveFitter.fitBuilder != null) {
                object2 = new ArrayList<FunctionPanel>(dataToolTab.curveFitter.fitBuilder.panels.values());
                xMLControl.setValue("fits", object2);
            }
            xMLControl.setValue("selected_fit", dataToolTab.curveFitter.getSelectedFitName());
            xMLControl.setValue("autofit", dataToolTab.curveFitter.autofitCheckBox.isSelected());
            if (!dataToolTab.curveFitter.autofitCheckBox.isSelected()) {
                void var7_10;
                object2 = new double[dataToolTab.curveFitter.paramModel.getRowCount()];
                boolean n = false;
                while (var7_10 < ((DataFunction[])object2).length) {
                    stringArray = (String[])dataToolTab.curveFitter.paramModel.getValueAt((int)var7_10, 1);
                    object2[var7_10] = (DataFunction)stringArray.doubleValue();
                    ++var7_10;
                }
                xMLControl.setValue("fit_parameters", object2);
            }
            xMLControl.setValue("fit_color", dataToolTab.curveFitter.color);
            xMLControl.setValue("fit_visible", dataToolTab.bottomPaneCheckbox.isSelected());
            xMLControl.setValue("props_visible", dataToolTab.propsCheckbox.isSelected());
            xMLControl.setValue("stats_visible", dataToolTab.statsCheckbox.isSelected());
            int n = dataToolTab.splitPanes[0].getDividerLocation();
            xMLControl.setValue("split_pane", n);
            n = dataToolTab.curveFitter.splitPane.getDividerLocation();
            xMLControl.setValue("fit_split_pane", n);
            int[] nArray = dataToolTab.dataTable.getModelColumnOrder();
            xMLControl.setValue("column_order", nArray);
            stringArray = dataToolTab.dataTable.getHiddenMarkers();
            xMLControl.setValue("hidden_markers", stringArray);
            Collection<String> collection = dataToolTab.dataTable.getPatternColumns();
            if (!collection.isEmpty()) {
                ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
                for (String string : collection) {
                    String string2 = dataToolTab.dataTable.getFormatPattern(string);
                    arrayList2.add(new String[]{string, string2});
                }
                xMLControl.setValue("format_patterns", arrayList2);
            }
        }

        public Object createObject(XMLControl xMLControl) {
            DatasetManager datasetManager = (DatasetManager)xMLControl.getObject("data");
            return new DataToolTab(datasetManager, null);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Runnable runnable2;
            String[] stringArray;
            Serializable serializable;
            XMLControl[] xMLControlArray;
            Object object22;
            final DataToolTab dataToolTab = (DataToolTab)object;
            dataToolTab.setName(xMLControl.getString("name"));
            for (Object object22 : xMLControl.getPropertyContent()) {
                if (!object22.getPropertyName().equals("data_functions")) continue;
                xMLControlArray = object22.getChildControls();
                int n = 0;
                while (n < xMLControlArray.length) {
                    DataFunction dataFunction = new DataFunction(dataToolTab.dataManager);
                    xMLControlArray[n].loadObject(dataFunction);
                    dataFunction.setXColumnVisible(false);
                    dataToolTab.dataManager.addDataset(dataFunction);
                    ++n;
                }
                serializable = dataToolTab.dataManager.getDatasets();
                int n2 = 0;
                while (n2 < ((ArrayList)serializable).size()) {
                    if (((ArrayList)serializable).get(n2) instanceof DataFunction) {
                        ((DataFunction)((ArrayList)serializable).get(n2)).refreshFunctionData();
                    }
                    ++n2;
                }
                dataToolTab.dataTable.refreshTable();
                break;
            }
            object22 = (ArrayList)xMLControl.getObject("fits");
            if (object22 != null) {
                xMLControlArray = ((ArrayList)object22).iterator();
                while (xMLControlArray.hasNext()) {
                    serializable = (FitFunctionPanel)xMLControlArray.next();
                    dataToolTab.curveFitter.addUserFit((FitFunctionPanel)serializable);
                }
            }
            xMLControlArray = xMLControl.getString("selected_fit");
            dataToolTab.curveFitter.fitDropDown.setSelectedItem(xMLControlArray);
            boolean bl = xMLControl.getBoolean("autofit");
            dataToolTab.curveFitter.autofitCheckBox.setSelected(bl);
            double[] dArray = (double[])xMLControl.getObject("fit_parameters");
            if (dArray != null) {
                int n = 0;
                while (n < dArray.length) {
                    dataToolTab.curveFitter.setParameterValue(n, dArray[n]);
                    ++n;
                }
            }
            Color color = (Color)xMLControl.getObject("fit_color");
            dataToolTab.curveFitter.setColor(color);
            boolean bl2 = xMLControl.getBoolean("fit_visible");
            dataToolTab.bottomPaneCheckbox.setSelected(bl2);
            bl2 = xMLControl.getBoolean("props_visible");
            dataToolTab.propsCheckbox.setSelected(bl2);
            bl2 = xMLControl.getBoolean("stats_visible");
            dataToolTab.statsCheckbox.setSelected(bl2);
            final int n = xMLControl.getInt("split_pane");
            final int n3 = xMLControl.getInt("fit_split_pane");
            int[] nArray = (int[])xMLControl.getObject("column_order");
            dataToolTab.dataTable.setModelColumnOrder(nArray);
            if (nArray == null && (stringArray = (String[])xMLControl.getObject("working_columns")) != null) {
                dataToolTab.dataTable.setWorkingColumns(stringArray[0], stringArray[1]);
            }
            stringArray = (String[])xMLControl.getObject("hidden_markers");
            dataToolTab.dataTable.hideMarkers(stringArray);
            ArrayList arrayList = (ArrayList)xMLControl.getObject("format_patterns");
            if (arrayList != null) {
                for (Runnable runnable2 : arrayList) {
                    dataToolTab.dataTable.setFormatPattern(runnable2[0], runnable2[1]);
                }
            }
            runnable2 = new Runnable(){

                public synchronized void run() {
                    dataToolTab.bottomPaneAction.actionPerformed(null);
                    dataToolTab.propsAndStatsAction.actionPerformed(null);
                    dataToolTab.splitPanes[0].setDividerLocation(n);
                    dataToolTab.curveFitter.splitPane.setDividerLocation(n3);
                    dataToolTab.dataTable.refreshTable();
                    dataToolTab.propsTable.refreshTable();
                    dataToolTab.tabChanged(false);
                }
            };
            SwingUtilities.invokeLater(runnable2);
            return object;
        }
    }

    class SelectionBox
    extends Rectangle
    implements Drawable {
        boolean visible = true;
        int xstart;
        int ystart;
        int zoomSize = 10;
        Color color = new Color(0, 255, 0, 127);

        SelectionBox() {
        }

        public void setSize(int n, int n2) {
            int n3 = Math.min(0, n);
            int n4 = Math.min(0, n2);
            n = Math.abs(n);
            n2 = Math.abs(n2);
            super.setLocation(this.xstart + n3, this.ystart + n4);
            super.setSize(n, n2);
        }

        public void draw(DrawingPanel drawingPanel, Graphics graphics) {
            if (this.visible) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(this.color);
                graphics2D.draw(this);
            }
        }

        public boolean isZoomable() {
            return this.getBounds().width > this.zoomSize && this.getBounds().height > this.zoomSize;
        }
    }
}

